<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Support\Facades\DB;

class VisiosoftModuleSmartaxCreateSegmentationStream extends Migration
{
    protected $delete = false;

    protected $stream = [
        'slug' => 'segmentation',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => true,
        'sortable' => false,
    ];

    protected $fields = [
        'bbox_id' => 'anomaly.field_type.integer',
        'segmentation' => 'anomaly.field_type.textarea', // json
        'sequence_uuid' => 'anomaly.field_type.text',
    ];

    protected $assignments = [
        'bbox_id',
        'segmentation',
        'sequence_uuid'
    ];
}
