<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSmartaxCreateBboxStream extends Migration
{
    protected $delete = false;

    protected $stream = [
        'slug' => 'bbox',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => true,
        'sortable' => false,
    ];

    protected $fields = [
        'x_min' => 'anomaly.field_type.decimal',
        'y_min' => 'anomaly.field_type.decimal',
        'x_max' => 'anomaly.field_type.decimal',
        'y_max' => 'anomaly.field_type.decimal',
        'score' => 'anomaly.field_type.decimal',
        'photo_uuid' => 'anomaly.field_type.text',
        'bbox_key' => 'anomaly.field_type.text',
        'sequence_uuid' => 'anomaly.field_type.text',
    ];

    protected $assignments = [
        'x_min',
        'y_min',
        'x_max',
        'y_max',
        'score',
        'photo_uuid',
        'bbox_key',
        'sequence_uuid',
    ];
}
