<?php namespace Visiosoft\SmartaxModule\User\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ConnectModule\User\UserModel;

class UserFormBuilder extends FormBuilder
{
    protected $model = UserModel::class;

    public function onPosting(Request $request, UserRepositoryInterface $repository)
    {
        if (!$repository->findByEmail($request->get('email'))) {
            $this->addFormError('email', trans('streams::validation.unique', ['attribute' => 'Email']));
        }

        if (!$request->get('password') && $this->form->getMode() == 'edit') {
            $this->disableFormField('password');
        };
    }

    public function onBuilt(UserRepositoryInterface $repository, MessageBag $messageBag)
    {
        $user = $repository->newQuery()->find(Auth::id());

        if (!$user->hasRole('smartax_admin')) {
            $messageBag->error([trans('streams::error.404.name')]);
            $this->setFormResponse(redirect('/admin/smartax/users'));
        }
    }

    protected $options = [
        'redirect' => '/admin/smartax/users',
    ];
}
