<?php namespace Visiosoft\SmartaxModule;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class SmartaxExport implements WithMapping, FromCollection, WithHeadings
{
    protected $entries;

    public function __construct($entries)
    {
        $this->entries = $entries;
    }
    public function collection()
    {
        return collect($this->entries);
    }

    public function map($entry): array
    {
        return [
            $entry['id'],
            $entry['thumbnail'],
            $entry['lat'],
            $entry['lon'],
            $entry['area'],
            $entry['created_at'],
            $entry['neighborhood'],
            $entry['road'],
            $entry['number'],
        ];
    }

    public function headings(): array
    {
        return [
            'ID',
            'Önizleme',
            'Latitude',
            'Longitude',
            'Alan m²',
            'Oluşturulma Zamanı',
            'Mahalle',
            'Yol / Cadde veya Sokak',
            'Kapı Numarası',
        ];
    }
}
