<?php namespace Visiosoft\SmartaxModule\InstallerForm;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\UserActivator;
use Anomaly\UsersModule\User\UserModel;

class InstallerFormHandler
{
    protected $users;

    protected $roles;

    protected $activator;

    public function __construct(
        UserRepositoryInterface $users,
        RoleRepositoryInterface $roles,
        UserActivator $activator
    ) {
        $this->users     = $users;
        $this->roles     = $roles;
        $this->activator = $activator;
    }


    public function handle(InstallerFormBuilder $builder, SettingRepositoryInterface $repository)
    {
        if ($builder->hasFormErrors()) {
            return;
        }

        $repository->set('visiosoft.module.smartax::project_key', $builder->getPostValue('project_key'));
        $repository->set('visiosoft.module.smartax::organization_key', $builder->getPostValue('organization_key'));
        $repository->set('visiosoft.module.smartax::token', $builder->getPostValue('token'));

        $admin = $this->roles->findBySlug('smartax_admin');

        $administrator = new UserModel();
        $administrator->setAttribute('display_name', 'Smartax Administrator');
        $administrator->setAttribute('email', $builder->getPostValue('admin_email'));
        $administrator->setAttribute('username', $builder->getPostValue('admin_username'));
        $administrator->setAttribute('password', $builder->getPostValue('admin_password'));

        $administrator->save();

        $administrator->roles()->sync([$admin->getId()]);

        $this->activator->force($administrator);

        // Wait for saved config file
        sleep(3);

        $builder->setFormResponse(redirect('/admin/login'));
    }
}
 
