<?php namespace Visiosoft\SmartaxModule\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckInstaller
{
    public function handle(Request $request, Closure $next)
    {
        if ($request->path() != "smartax/install") {
            $settings = [
                'project_key',
                'organization_key',
                'token',
            ];

            foreach ($settings as $setting) {
                if (!config('visiosoft.module.smartax::' . $setting)) {
                    return redirect('/smartax/install');
                }
            }
        } else {
            $ready = true;

            $settings = [
                'project_key',
                'organization_key',
                'token',
            ];

            foreach ($settings as $setting) {
                if (!config('visiosoft.module.smartax::' . $setting)) {
                    $ready = false;
                }
            }

            if ($ready || $request->has('completed')) {
                return redirect('/admin/login');
            }
        }

        return $next($request);
    }
}
