"use strict";
let reportTable;
const filter = $('.filter-dd-wrapper')

function getSearchParameter(key) {
    let searchParams = new URLSearchParams(window.location.search);

    return searchParams.get(key)
}

// function filterTable(e) {
//     e.preventDefault();
//     var params = {};
//     $('.datatable-input').each(function () {
//         var i = $(this).data('col-index');
//         if (params[i]) {
//             params[i] += '|' + $(this).val();
//         } else {
//             params[i] = $(this).val();
//         }
//     });
//     $.each(params, function (i, val) {
//         // apply search params to datatable
//         datatable.column(i).search(val ? val : '', false, false);
//     });
//     datatable.table().draw();
// }

let initTable = function () {
    return $('#reportTable').DataTable({
        responsive: true,

        dom: `<'row'<'col-sm-12'tr>>
			<'row'<'col d-flex justify-content-between'pli>>`,
        lengthMenu: [[5, 10, 15, 20, 50, -1], [5, 10, 15, 20, 50, "All"]],
        pageLength: 15,
        language: {
            'lengthMenu': '_MENU_',
        },
        info: false,
        searchDelay: 500,
        processing: true,
        serverSide: true,
        ajax: {
            url: '/api/smartax/features',
            type: 'GET',
            data: {
                columnsDef: [
                    'id',
                    'area',
                    'formatted_created_at',
                ],
            },
        },
        toolbar: {
            items: {
                info: true
            }
        },
        select: {
            style: "multi",
            selector: "td:first-child .checkable"
        },

        layout: {
            scroll: true, // enable/disable datatable scroll both horizontal and
            footer: false // display/hide footer
        },

        rows: {
            autoHide: false,
        },
        createdRow(row, data, dataIndex) {
            $(row).attr('data-id', data.id);
        },
        orderable: false,
        searchCols: [
            null,
            {"search": getSearchParameter('street')},
            {"search": getSearchParameter('road')},
        ],
        pagination: true,

        search: {
            input: $('#kt_datatable_search_query'),
            key: 'generalSearch'
        },

        autoWidth: false,
        columns: [
            {
                width: "70px",
                data: 'id',
                orderable: false,
            },
            {
                orderable: false,
                data: 'district',
                render: function (data, type, row) {
                    return row.district_name;
                }
            },
            {
                orderable: false,
                data: 'road',
                render: function (data, type, row) {
                    return row.road_name;
                }
            },
            {
                orderable: false,
                width: "70px",
                data: 'door',
                render: function (data, type, row) {
                    return row.door_name;
                }
            },
            {
                orderable: false,
                data: 'area',
                width: "100px",
                render: function (data, type, row) {
                    return parseFloat(data).toFixed(2) + ' m²';
                }
            },
            {
                orderable: false,
                data: 'price',
                width: "100px",
                render: function (data, type, row) {
                    return data + '₺';
                }
            },
            {
                orderable: false,
                width: "150px",
                data: 'created_at',
                sortable: false
            },
        ],
    });
};
const conn = {
    serviceUrl: "/api/smartax/geo-features/",
    street: {
        get url() {
            return conn.serviceUrl + "yol";
        },
        rel: "mahalle_id",
        mapRel: "?mahalle_id",
        field: ["yol_adi"],
        stroke: [38, 198, 218, .75],
        hover: '#8950FC',
        width: 5,
        id: "yol_id",
        breadcrumb: 'Yol',
    },
    road: {
        get url() {
            return conn.serviceUrl + "yol";
        },
        rel: "?mahalle_id",
        mapRel: "?objectid",
        field: ["yol_adi"],
        hover: false,
        width: 6,
        id: "yol_id",
        breadcrumb: 'Yol Detay',
    },
    door: {
        get url() {
            return conn.serviceUrl + "kapi";
        },
        rel: "?yol_id",
        hover: false,
        mapRel: "objectid",
        field: ["kapi_no"],
        id: "objectid",
    },
    allDoors: {
        get url() {
            return conn.serviceUrl + "kapi";
        },
        rel: "yol_id",
        hover: false,
        mapRel: "?yol_id",
        field: ["kapi_no"],
        id: "objectid",
    },
    firstRoad: true,
    startingPoint: {
        field: ["adi_numara"],
        id: "objectid",
        get url() {
            return conn.serviceUrl + "mahalle"
        },
    }
};

let initFunctions = function () {
    //TODO make filters

    $('#kt_reset').on('click', function (e) {
        e.preventDefault();
        resetUrlParams();
        reportTable.search('').columns().search('').draw();

        $.each($('.report-filter').find('.dropdown'), function (i, dropdown) {
            $(dropdown).find('button').removeClass('active');
            $(dropdown).find('a.active').removeClass('active');

            let type = $(dropdown).parent().data('name');

            if (type === 'road') {
                $('button > span', dropdown).text('Sokak/Yol ara')
            } else if (type === 'door') {
                $('button > span', dropdown).text('Kapi No ara')
            } else if (type === 'street') {
                $('button > span', dropdown).text('Mahalle ara')
            }
        });

    });

    // $('#dateStartFilter, #dateEndFilter').datepicker();

    // $('#keywordInput, #statusFilter, #dateStartFilter, #dateEndFilter').on('change', filterTable);

    new $.fn.dataTable.Buttons(reportTable, {
        buttons: [
            {
                extend: 'collection',
                className: 'py-1 text-white font-weight-bolder dropdown-toggle',
                text: '<span class="svg-icon svg-icon-md">\n' +
                    '                                    <svg id="Stockholm-icons-_-Files-_-Export"\n' +
                    '                                         data-name="Stockholm-icons-/-Files-/-Export" xmlns="http://www.w3.org/2000/svg"\n' +
                    '                                         width="24" height="24" viewBox="0 0 24 24">\n' +
                    '                                      <rect id="bound" width="24" height="24" fill="none"/>\n' +
                    '                                      <path id="Path-103"\n' +
                    '                                            d="M17,8a1,1,0,0,1,0-2h1a4,4,0,0,1,4,4v8a4,4,0,0,1-4,4H6a4,4,0,0,1-4-4V9.993a4,4,0,0,1,4-4H7a1,1,0,0,1,0,2H6a2,2,0,0,0-2,2V18a2,2,0,0,0,2,2H18a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2Z"\n' +
                    '                                            fill="#fff"/>\n' +
                    '                                      <rect id="Rectangle" width="2" height="12" rx="1"\n' +
                    '                                            transform="translate(13 14) rotate(180)" fill="#fff"/>\n' +
                    '                                      <path id="Path-104"\n' +
                    '                                            d="M12-2.586,14.293-.293a1,1,0,0,0,1.414,0,1,1,0,0,0,0-1.414l-3-3a1,1,0,0,0-1.414,0l-3,3a1,1,0,0,0,0,1.414,1,1,0,0,0,1.414,0Z"\n' +
                    '                                            transform="translate(0 5)" fill="#fff"/>\n' +
                    '                                    </svg>\n' +
                    '                                </span>Export',
                buttons: [
                    {
                        extend: 'pdf',
                        title: 'Rapor ' + new Date().toISOString().slice(0, 10),
                        className: 'navi-item',
                        exportOptions: {
                            modifer: {
                                page: 'all',
                            }
                        },
                        text: '<span class="svg-icon svg-icon-md"><svg xmlns="http://www.w3.org/2000/svg" width="22" height="22.097" viewBox="0 0 22 22.097">\n' +
                            '    <rect id="bound" width="22" height="22" transform="translate(-0.424 -0.424)" fill="none"/>\n' +
                            '    <g id="file_1_" data-name="file (1)" transform="translate(-53.333 21.528)">\n' +
                            '      <g id="Group_70245" data-name="Group 70245" transform="translate(55 -22)">\n' +
                            '        <path id="Subtraction_70" data-name="Subtraction 70" d="M-23890.055-1691.856h-14.254a1.785,1.785,0,0,1-1.783-1.782v-18.533a1.785,1.785,0,0,1,1.783-1.782h7.248a1.774,1.774,0,0,1,1.26.522l7.006,7.008a1.764,1.764,0,0,1,.523,1.26v11.525A1.785,1.785,0,0,1-23890.055-1691.856Zm-7.787-15.149a.653.653,0,0,0-.666.42,7.726,7.726,0,0,0,.408,3.51l-.107.252c-.281.7-.633,1.387-.945,2l-.016.031-.041.078c-.371.719-.66,1.252-.912,1.68l-.281.15c-.018.008-.508.268-.625.342a3.434,3.434,0,0,0-1.715,1.752.435.435,0,0,0,.16.48l.277.138a.833.833,0,0,0,.371.09c.688,0,1.486-.859,2.592-2.784a25.407,25.407,0,0,1,4-.948,6.973,6.973,0,0,0,2.91.924,1.151,1.151,0,0,0,.342-.042.6.6,0,0,0,.342-.228,1.23,1.23,0,0,0,.133-.834.584.584,0,0,0-.162-.282,2.3,2.3,0,0,0-1.471-.348h-.086a12.67,12.67,0,0,0-1.684.132,4.189,4.189,0,0,1-.816-.57,5.9,5.9,0,0,1-1.482-2.292l.018-.072q.012-.056.023-.109l.014-.053a15.485,15.485,0,0,0,.264-2.688.614.614,0,0,0-.033-.156l-.014-.042-.031-.078a.655.655,0,0,0-.561-.444h-.021l-.174-.006Zm-4.242,10.4,0,0a4.838,4.838,0,0,1,1.361-1.63c.023-.018.066-.057.131-.117l.133-.123a5.2,5.2,0,0,1-1.625,1.871Zm9.7-2.886a4.538,4.538,0,0,1-1.6-.48c.238-.021.473-.03.738-.03h.121a2.577,2.577,0,0,1,.8.1c.311.081.355.219.361.259a.086.086,0,0,1-.031.089A1.03,1.03,0,0,1-23892.389-1699.493Zm-6.635,0,0,0c.094-.169.2-.352.309-.56q.085-.154.17-.313a17.681,17.681,0,0,0,.84-1.836,6.035,6.035,0,0,0,1.385,1.722c.061.046.123.1.184.146l.033.028a17.511,17.511,0,0,0-2.92.815Zm1.393-4.908v0a5.611,5.611,0,0,1-.187-1.45,2.783,2.783,0,0,1,.076-.784.022.022,0,0,1,.016-.008c.221,0,.348.543.359,1.08a2.261,2.261,0,0,1-.264,1.162Z" transform="translate(23906.09 1713.953)" fill="#d0d0d0"/>\n' +
                            '      </g>\n' +
                            '    </g>\n' +
                            '</svg>\n</span>PDF',
                    },
                    {
                        extend: 'print',
                        className: 'navi-item',
                        title: 'Rapor ' + new Date().toISOString().slice(0, 10),
                        exportOptions: {
                            modifer: {
                                page: 'all',
                            }
                        },
                        text: '<span class="svg-icon svg-icon-md"><svg xmlns="http://www.w3.org/2000/svg" width="22.559" height="22.559" viewBox="0 0 22.559 22.559">\n' +
                            '    <rect id="bound" width="21.719" height="21.719" transform="translate(-0.424 -0.424)" fill="none"/>\n' +
                            '    <path id="printer_3_" data-name="printer (3)"\n' +
                            '          d="M22.142,10.057H6.834V9.251a.806.806,0,0,1,.806-.806h3.223a.806.806,0,0,0,.806-.806V4.417a.806.806,0,0,1,.806-.806h6.445a.806.806,0,0,1,.806.806V8.445a.806.806,0,0,0,1.611,0V4.417A2.424,2.424,0,0,0,18.919,2H11.531a2.382,2.382,0,0,0-1.708.709L5.932,6.6a2.382,2.382,0,0,0-.709,1.708v1.748H4.417A2.424,2.424,0,0,0,2,12.474v6.445a2.424,2.424,0,0,0,2.417,2.417h.806v.806A2.424,2.424,0,0,0,7.64,24.559H18.919a2.424,2.424,0,0,0,2.417-2.417v-.806h.806a2.424,2.424,0,0,0,2.417-2.417V12.474a2.424,2.424,0,0,0-2.417-2.417ZM9.251,12.474a.806.806,0,1,1-.806.806A.806.806,0,0,1,9.251,12.474ZM6.834,14.085a.806.806,0,1,1,.806-.806A.806.806,0,0,1,6.834,14.085Zm12.891,8.057a.806.806,0,0,1-.806.806H7.64a.806.806,0,0,1-.806-.806V17.308H19.725Z"\n' +
                            '          transform="translate(-2.844 -2.844)" fill="#d0d0d0"/>\n' +
                            '</svg>\n</span>Print',
                    },
                    {
                        extend: 'excel',
                        title: 'Rapor ' + new Date().toISOString().slice(0, 10),
                        className: 'navi-item',
                        exportOptions: {
                            modifer: {
                                page: 'all',
                            }
                        },
                        text: '<span class="svg-icon svg-icon-md"><svg xmlns="http://www.w3.org/2000/svg" width="23.076" height="22" viewBox="0 0 23.076 22">\n' +
                            '    <rect id="bound" width="22" height="22" transform="translate(-0.424 -0.424)" fill="none"/>\n' +
                            '    <g id="microsoft-excel" transform="translate(-0.961 -0.24)">\n' +
                            '        <path id="Subtraction_72" data-name="Subtraction 72"\n' +
                            '              d="M-23892.648-1661.321h-10.1a.722.722,0,0,1-.721-.72v-2.832a.728.728,0,0,0,.721.666h2.885a.724.724,0,0,0,.727-.72.724.724,0,0,0-.727-.72h-2.885a.721.721,0,0,0-.717.666l0-2.778a.728.728,0,0,0,.721.666h2.885a.724.724,0,0,0,.727-.72.724.724,0,0,0-.727-.72h-2.885a.721.721,0,0,0-.717.666l0-2.777a.73.73,0,0,0,.721.672h2.885a.727.727,0,0,0,.727-.726.724.724,0,0,0-.727-.72h-2.885a.721.721,0,0,0-.717.666l0-2.772a.728.728,0,0,0,.721.666h2.885a.724.724,0,0,0,.727-.72.727.727,0,0,0-.727-.726h-2.885a.724.724,0,0,0-.717.672l0-2.831a.722.722,0,0,1,.721-.72h10.1a.724.724,0,0,1,.725.72v14.422A.724.724,0,0,1-23892.648-1661.321Zm-4.326-4.325a.72.72,0,0,0-.719.72.72.72,0,0,0,.719.72h1.445a.72.72,0,0,0,.721-.72.72.72,0,0,0-.721-.72Zm0-2.885a.72.72,0,0,0-.719.72.72.72,0,0,0,.719.72h1.445a.72.72,0,0,0,.721-.72.72.72,0,0,0-.721-.72Zm0-2.885a.72.72,0,0,0-.719.72.723.723,0,0,0,.719.726h1.445a.724.724,0,0,0,.721-.726.72.72,0,0,0-.721-.72Zm0-2.885a.723.723,0,0,0-.719.726.72.72,0,0,0,.719.72h1.445a.72.72,0,0,0,.721-.72.723.723,0,0,0-.721-.726Z"\n' +
                            '              transform="translate(23915 1680.069)" fill="#d0d0d0"/>\n' +
                            '        <path id="Subtraction_71" data-name="Subtraction 71"\n' +
                            '              d="M-23891.2-1655.554a.723.723,0,0,1-.141-.014l-11.541-2.16a.726.726,0,0,1-.588-.708V-1674.3a.726.726,0,0,1,.588-.708l11.541-2.166a.723.723,0,0,1,.141-.014.721.721,0,0,1,.455.164.737.737,0,0,1,.258.558v20.187a.737.737,0,0,1-.258.558A.721.721,0,0,1-23891.2-1655.554Zm-5.533-9.852h0l2.1,2.393a.708.708,0,0,0,.492.252h.043a.728.728,0,0,0,.479-.18.721.721,0,0,0,.244-.5.71.71,0,0,0-.178-.523l-2.279-2.6,2.309-2.964a.727.727,0,0,0-.125-1.014.722.722,0,0,0-.443-.152.723.723,0,0,0-.57.278l-2.137,2.748-1.8-2.058a.727.727,0,0,0-.562-.27.682.682,0,0,0-.127.012.727.727,0,0,0-.559.486.734.734,0,0,0,.162.72l1.986,2.268-2.016,2.585a.716.716,0,0,0-.143.538.7.7,0,0,0,.273.47.709.709,0,0,0,.443.154.716.716,0,0,0,.57-.28l1.836-2.363Z"\n' +
                            '              transform="translate(23903.463 1677.184)" fill="#d0d0d0"/>\n' +
                            '    </g>\n' +
                            '</svg>\n</span>Excel',
                    },
                ],
            }
        ]
    }).container().appendTo($('.exportTable'));

};

const expandedSearch = {
    searchParams: new URLSearchParams(window.location.search),

    queryLocation() {
        return {
            street: this.searchParams.get('street'),
            road: this.searchParams.get('road'),
        }
    },

    queryProcessed: {
        street: false,
        road: false,
    },
    ajaxRequest(params, i, v) {
        let url = params.rel ? params.url + params.rel + "=" + v : params.url;
        fetch(url).then(function (data) {
            return data.json()
        }).then(response => {
            expandedSearch.Lister(response, params, i)
        }).catch(function (error) {
            //errorS();
        })
    },
    handleQuery() {
        if (this.queryLocation().street && !this.queryProcessed.street && $('.filter-dd-wrapper[data-name=street] .dropdown-item').length) {
            this.queryProcessed.street = true;

            $('.filter-dd-wrapper[data-name=street]').find(`[data-val=${this.queryLocation().street}]`).click()
        }

        if (this.queryLocation().road && !this.queryProcessed.road && $('.filter-dd-wrapper[data-name=road] .dropdown-item').length) {
            this.queryProcessed.road = true;

            $('.filter-dd-wrapper[data-name=road]').find(`[data-val=${this.queryLocation().road}]`).click()
        }
    },
    Lister(response, params, index) {
        filter.eq(index).find('.dropdown-menu').html('');

        filter.eq(index).find('.dropdown-menu').append(
            // data.filter(p=>p.src.split('.').pop() !== "json").map(p=>p.src);
            response.features.map(t => `
                <a class="dropdown-item py-2" data-val="${t.properties[params.id]}">
                    <span class="text-truncate">${params.field.map(fields => t.properties[fields])}</span>
                </a>
            `)
        );

        this.handleQuery()
    },
    init() {
        expandedSearch.ajaxRequest(conn.startingPoint, 0);
        filter.each(function (index, item) {
            filter.eq(index).on('click', '.dropdown-menu .dropdown-item', function () {
                $(this).addClass('active')
                    .siblings()
                    .removeClass('active')
                    .closest('.dropdown')
                    .find('.dropdown-toggle')
                    .addClass('active')
                    .find('span')
                    .text($(this).text())

                const nextDropdowns = $(this).closest('.filter-dd-wrapper')
                    .nextAll()
                    .find('.dropdown-toggle')
                    .removeClass('active')

                for (let dropdown of nextDropdowns) {
                    dropdown = $(dropdown)
                    const name = $(dropdown).closest('.filter-dd-wrapper').data('name')
                    if (name === 'road') {
                        $('span', dropdown).text('Sokak/Yol ara')
                    } else if (name === 'door') {
                        $('span', dropdown).text('Kapi No ara')
                    }
                }

                nextDropdowns.siblings('.dropdown-menu').html('')

                const ajaxIndex = index === 2 ? index - 1 : index

                if (index === 0) {
                    conn.firstRoad = true
                } else if (index === 1) {
                    conn.firstRoad = false
                }

                if (index !== 2) {
                    expandedSearch.ajaxRequest(
                        conn[filter.eq(ajaxIndex + 1).data('name')], ajaxIndex + 1, $(this).data('val')
                    )
                }

                const type = $(this).closest('.filter-dd-wrapper').data('name');

                if (['street', 'road'].includes(type)) {
                    const url = addMapParams(type, $(this).data('val'));
                }
                if (type == 'street') {
                    searchDistrict($(this).data('val'));
                } else if (type == 'road') {
                    searchRoad($(this).data('val'));
                } else if (type == 'door') {
                    searchDoor($(this).data('val'));
                }
            })
        });
    }
};

function searchDistrict(id) {
    reportTable.column(1).search(id, false, false);
    reportTable.table().draw();
};

function searchRoad(id) {
    reportTable.column(2).search(id, false, false);
    reportTable.table().draw();
};

function searchDoor(id) {
    reportTable.column(3).search(id, false, false);
    reportTable.table().draw();
};

function resetUrlParams() {
    const urlParams = new URLSearchParams(window.location.search);

    urlParams.delete('road');
    urlParams.delete('street');

    const refresh = `${window.location.protocol}//${window.location.host + window.location.pathname}?${urlParams}`;
    window.history.pushState({path: refresh}, '', refresh);

    return refresh;

}

function addMapParams(type, value) {
    const urlParams = new URLSearchParams(window.location.search);

    if (type === 'street') {
        urlParams.delete('road');
    }

    urlParams.set(type, value);

    const refresh = `${window.location.protocol}//${window.location.host + window.location.pathname}?${urlParams}`;
    window.history.pushState({path: refresh}, '', refresh);

    return refresh;
}

jQuery(document).ready(function () {
    $.fn.dataTable.ext.errMode = 'none';

    reportTable = initTable();

    initFunctions();

    expandedSearch.init()

});