var pano_details = {};
var calculated = {};
var detail_id = $('.taxpayer-edit').data('id');
var completed_calculation_job = false;
var result_calculation = {};
var clicked_id =

    $(function () {
        var cropData = {};
        var crop_bbox = {};

        //Get Detail
        var details = crudX({
            url: '/points/detail/' + detail_id,
            type: 'GET',
            success: function (relations) {
                if (relations.length > 0) {
                    //Set Detail
                    var points_data = relations[relations.length - 1]

                    $('input[name="area"]').val(Math.round(points_data.area) + " m²")
                    $('input[name="coordinate"]').val(points_data.lat + ", " + points_data.lon)
                    $('input[name="captured_at"]').val(moment(points_data.bbox.detail.stamp).lang("tr").format('DD MMMM YYYY - HH:mm'));
                    $('iframe[name="street-view"]').attr('src', 'https://www.google.com/maps/embed?pb=!4v1553797194458!6m8!1m7!1sR4K_5Z2wRHTk9el8KLTh9Q!2m2!1d' + points_data.lat + '!2d' + points_data.lon + '!3f305.15097!4f0!5f0.7820865974627469');

                    //Set Image
                    $.each(relations, function (i, relation) {

                        var real_bbox = {
                            x_min: relation.bbox.x_min,
                            y_min: relation.bbox.y_min,
                            x_max: relation.bbox.x_max,
                            y_max: relation.bbox.y_max,
                            height: parseInt(relation.bbox.y_max) - parseInt(relation.bbox.y_min),
                            width: parseInt(relation.bbox.x_max) - parseInt(relation.bbox.x_min),
                        };

                        var render_bbox = {
                            left: (real_bbox.x_min > 100) ? 100 : 0,
                            top: (real_bbox.y_min > 100) ? 100 : 0,
                            width: ((8192 - real_bbox.x_max) > 100) ? 100 : 8192 - real_bbox.x_max,
                            height: ((4096 - real_bbox.y_max) > 100) ? 100 : 4096 - real_bbox.y_max,
                        };

                        crop_bbox[i] = {
                            xmin: parseInt(real_bbox.x_min) - render_bbox.left,
                            ymin: parseInt(real_bbox.y_min) - render_bbox.top,
                            xmax: parseInt(real_bbox.x_max) + render_bbox.width,
                            ymax: parseInt(real_bbox.y_max) + render_bbox.height
                        };

                        var pano_detail = relation.bbox.detail;

                        pano_details[i] = pano_detail;

                        var img_url = 'https://image.mapilio.com/api/extract/?src=h:/'
                            + pano_detail.dirname + '/' + pano_detail.filename + '/' + pano_detail.imgname +
                            "&xmax=" + crop_bbox[i].xmax + "&xmin=" + crop_bbox[i].xmin + "&ymax=" + crop_bbox[i].ymax + "&ymin="
                            + crop_bbox[i].ymin;

                        $('.picture-frame-' + i + ' > .crop-image').attr('src', img_url);

                        if ((relations.length - 1) == i) {
                            $('.detail-image').attr('src', img_url);
                            detailMap(detail_id, [points_data.lat, points_data.lon])
                        }


                        cropData[i] = {
                            left: render_bbox.left,
                            top: render_bbox.top,
                            height: real_bbox.height,
                            width: real_bbox.width,
                        };

                        calculated[i] = {
                            "x_min": crop_bbox[i].xmin + render_bbox.left,
                            "x_max": (crop_bbox[i].xmin + render_bbox.left) + real_bbox.width,
                            "y_min": crop_bbox[i].ymin + render_bbox.top,
                            "y_max": (crop_bbox[i].ymin + render_bbox.top) + real_bbox.height,
                        };
                    })
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: configration_calculation.error.title,
                        text: configration_calculation.error.message,
                    })
                }
            }
        });

        details.then(function () {
            $.each($('.crop-image'), function (i, v) {
                var image = $(this)

                image.cropper({
                    strict: false,
                    background: false,
                    guides: false,
                    rotatable: false,
                    zoomable: false,
                    responsive: false,
                    restore: true,
                    // viewMode: 2,
                });

                // Event
                image.on('built.cropper', function () {
                    image.cropper('setCropBoxData', cropData[i]);
                });

                image.on('crop.cropper', function () {
                    var data = image.cropper('getData');
                    var canvasData = image.cropper('getCanvasData');
                    var cropboxData = image.cropper('getCropBoxData');

                    calculated[i] = {
                        "x_min": crop_bbox[i].xmin + cropboxData.left,
                        "x_max": (crop_bbox[i].xmin + cropboxData.left) + cropboxData.width,
                        "y_min": crop_bbox[i].ymin + cropboxData.top,
                        "y_max": (crop_bbox[i].ymin + cropboxData.top) + cropboxData.height,
                    };
                });

            });


            //detail
            var detail_image = $('.detail-image');

            detail_image.cropper({
                strict: false,
                background: false,
                guides: false,
                rotatable: false,
                zoomable: false,
                responsive: false,
                restore: true,
            });

            detail_image.on('built.cropper', function () {
                detail_image.cropper('setCropBoxData', cropData[Object.keys(cropData)[Object.keys(cropData).length - 1]]);
                detail_image.cropper('disable');
            });

            detail_image.cropper.disabled();
        })
    });


function detailMap(title, coordinate) {
    var leaflet = new L.Map('editMap', {zoom: 20, center: new L.latLng(coordinate)});

    leaflet.addLayer(new L.TileLayer('http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png'));

    L.control.scale().addTo(leaflet);

    var leafletIcon = L.divIcon({
        html: `<span class="svg-icon svg-icon-widget-green svg-icon-3x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="24" width="24" height="0"/><path d="M5,10.5 C5,6 8,3 12.5,3 C17,3 20,6.75 20,10.5 C20,12.8325623 17.8236613,16.03566 13.470984,20.1092932 C12.9154018,20.6292577 12.0585054,20.6508331 11.4774555,20.1594925 C7.15915182,16.5078313 5,13.2880005 5,10.5 Z M12.5,12 C13.8807119,12 15,10.8807119 15,9.5 C15,8.11928813 13.8807119,7 12.5,7 C11.1192881,7 10,8.11928813 10,9.5 C10,10.8807119 11.1192881,12 12.5,12 Z" fill="#000000" fill-rule="nonzero"/></g></svg></span>`,
        bgPos: [20, 20],
        iconAnchor: [20, 37],
        popupAnchor: [0, -37],
        className: 'leaflet-marker'
    });

    var marker = L.marker(coordinate, {icon: leafletIcon}).addTo(leaflet);
    marker.bindPopup(title, {closeButton: false});
}

$('#calculate , #calculate-save').on('click', function () {

    var calculation_params = {"objects": []};
    clicked_id = $(this).attr('id');

    //Create Calculation Params
    $.each(pano_details, function (index, value) {
        var object = {
            "coordx": parseFloat(value.coordx),
            "coordy": parseFloat(value.coordy),
            "img_url": configration_calculation.image_url + "/h:/" + value.dirname + "/" + value.filename + "/" + value.imgname,
            "heading": parseFloat(value.heading),
            "bbox_coords": [
                parseFloat(calculated[index].x_min),
                parseFloat(calculated[index].y_min),
                parseFloat(calculated[index].x_max),
                parseFloat(calculated[index].y_max)
            ]
        };

        calculation_params.objects.push(object);
        calculation_params['id'] = detail_id;
    });

    //Send Calculation Request
    requestCalculation(calculation_params).then(function (response) {
        //Check Calculation Status
        setTimeout(function () {
            checkCalculationCompleted(response.id)
        }, configration_calculation.calculation_check_time);
    });

});

function requestCalculation(data) {
    return $.ajax({
        url: configration_calculation.api_url + "/calculation",
        type: "POST",
        data: JSON.stringify(data),
        beforeSend: function () {
            completed_calculation_job = false;
            showLoader(configration_calculation.calculating)
        },
        error: function (xhr, ajaxOptions, thrownError) {
            swal("Hesaplama Başarısız!", "Lütfen daha sonra tekrar deneyiniz.", "error");
        }
    });
}

function checkCalculationCompleted(id) {
    $.ajax({
        url: configration_calculation.api_url + '/task/' + id,
        type: 'GET',
        success: function (result) {
            if (result.status === "SUCCESS") {
                completed_calculation_job = true;
                result_calculation = result;
                result_calculation.calculate_at = moment().format('D-MM-Y H:m:s');

                //Calculated Completed
                if (clicked_id === "calculate-save") {
                    //Save Calculation
                    saveCalculation(false).then(function () {
                        savedCalculation();
                        calculationCompleted();
                    });
                } else {
                    //Show Calculation
                    calculationCompleted();
                }
            }
        },
        complete: function () {
            if (!completed_calculation_job) {
                setTimeout(function () {
                    checkCalculationCompleted(id)
                }, configration_calculation.calculation_check_time);
            }
        }
    });
}

function calculationCompleted() {
    Swal.fire({
        icon: 'success',
        customClass: 'swal-wide calculated-swal',
        html: '<span class="calculated-title">' + configration_calculation.translate_calculated.title + '</span>' +
            '<div class="calculated-box mt-15 p-3 row">' +
            '<div class="w-75 text-left px-10 py-8">' +
            '<h2>' + configration_calculation.translate_calculated.area_title + '</h2>' +
            '<p>' + configration_calculation.translate_calculated.area_message.replace("{date}", result_calculation.calculate_at) + '</p>' +
            '</div>' +
            '<div class="w-25 calculated-area">' +
            '<span>' + parseFloat(result_calculation.result.Recalculated_Object.area).toFixed(2) + ' m²</span>' +
            '</div>' +
            '</div>',
        focusConfirm: false,
        allowOutsideClick: false,
        showCancelButton: true,
        showConfirmButton: (clicked_id === "calculate") ? true : false,
        confirmButtonText: configration_calculation.translate_calculated.save,
        cancelButtonText: (clicked_id === "calculate") ? configration_calculation.translate_calculated.dont_save : configration_calculation.translate_calculated.close,
    }).then((result) => {
        if (result.isConfirmed) {
            saveCalculation();
        }
    })
}

function saveCalculation(show_completed_screen = true) {
    var calculation_values = result_calculation.result.Recalculated_Object;

    return crudX({
        url: configration_calculation.set_point_api_url,
        type: "POST",
        data: {
            'lat': calculation_values.coordx,
            'lon': calculation_values.coordy,
            'area': calculation_values.area,
            'geom': calculation_values.geom
        },
        beforeSend: function () {
            showLoader('Kaydediliyor...')
        },
        success: function (response) {
            if (response.status && show_completed_screen) {

                //Return SavedCalculation
                savedCalculation()
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            swal("Hesaplama Kayıt Edilemedi!", "Lütfen sonra Tekrar Deneyiniz.", "error");
        }
    })
}

function showLoader(message = '') {
    Swal.fire({
        title: message,
        imageUrl: configration_calculation.loading_spinner,
        allowOutsideClick: false,
        showConfirmButton: false,
        imageWidth: 200,
        imageHeight: 200,
    });
}

function savedCalculation(show_saved_screen = true) {
    var result_values = result_calculation.result.Recalculated_Object;
    $('input[name="area"]').val(parseFloat(result_values.area).toFixed(2) + ' m²');
    $('input[name="coordinate"]').val(result_values.coordx + ", " + result_values.coordy);

    if (show_saved_screen) {
        Swal.fire({
            icon: 'success',
            showConfirmButton: false,
            timer: 1000
        })
    }
}