<?php namespace Visiosoft\SmartaxModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;
use Visiosoft\SmartaxModule\Point\PointRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxPointsEntryModel;
use Visiosoft\SmartaxModule\Point\PointModel;
use Visiosoft\SmartaxModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\SmartaxModule\Location\LocationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxLocationEntryModel;
use Visiosoft\SmartaxModule\Location\LocationModel;
use Visiosoft\SmartaxModule\Measurement\Contract\MeasurementRepositoryInterface;
use Visiosoft\SmartaxModule\Measurement\MeasurementRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxMeasurementEntryModel;
use Visiosoft\SmartaxModule\Measurement\MeasurementModel;
use Visiosoft\SmartaxModule\Relation\Contract\RelationRepositoryInterface;
use Visiosoft\SmartaxModule\Relation\RelationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxRelationEntryModel;
use Visiosoft\SmartaxModule\Relation\RelationModel;
use Visiosoft\SmartaxModule\Segmentation\Contract\SegmentationRepositoryInterface;
use Visiosoft\SmartaxModule\Segmentation\SegmentationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxSegmentationEntryModel;
use Visiosoft\SmartaxModule\Segmentation\SegmentationModel;
use Visiosoft\SmartaxModule\Bbox\Contract\BboxRepositoryInterface;
use Visiosoft\SmartaxModule\Bbox\BboxRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxBboxEntryModel;
use Visiosoft\SmartaxModule\Bbox\BboxModel;
use Visiosoft\SmartaxModule\Detected\Contract\DetectedRepositoryInterface;
use Visiosoft\SmartaxModule\Detected\DetectedRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxDetectedEntryModel;
use Visiosoft\SmartaxModule\Detected\DetectedModel;
use Visiosoft\SmartaxModule\Taxation\Contract\TaxationRepositoryInterface;
use Visiosoft\SmartaxModule\Taxation\TaxationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxTaxationEntryModel;
use Visiosoft\SmartaxModule\Taxation\TaxationModel;
use Illuminate\Routing\Router;

class SmartaxModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/smartax/points'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@index',
        'admin/smartax/points/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@create',
        'admin/smartax/points/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@edit',
        'admin/smartax/location'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@index',
        'admin/smartax/location/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@create',
        'admin/smartax/location/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@edit',
        'admin/smartax/measurement'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\MeasurementController@index',
        'admin/smartax/measurement/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\MeasurementController@create',
        'admin/smartax/measurement/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\MeasurementController@edit',
        'admin/smartax/relation'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\RelationController@index',
        'admin/smartax/relation/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\RelationController@create',
        'admin/smartax/relation/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\RelationController@edit',
        'admin/smartax/segmentation'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SegmentationController@index',
        'admin/smartax/segmentation/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SegmentationController@create',
        'admin/smartax/segmentation/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SegmentationController@edit',
        'admin/smartax/bbox'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\BboxController@index',
        'admin/smartax/bbox/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\BboxController@create',
        'admin/smartax/bbox/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\BboxController@edit',
        'admin/smartax/detected'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\DetectedController@index',
        'admin/smartax/detected/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\DetectedController@create',
        'admin/smartax/detected/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\DetectedController@edit',
        // Admin TaxationController
        'admin/smartax'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@index',
        'admin/smartax/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@create',
        'admin/smartax/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@edit',

        // Admin LocationController
        'admin/location' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@edit',
        'admin/smartax/report' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@report',

        // Taxpayer Controller
        'admin/taxpayer/detail' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxpayerController@detail',
        'admin/taxpayer/edit' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxpayerController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SmartaxModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SmartaxModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\SmartaxModule\Event\ExampleEvent::class => [
        //    Visiosoft\SmartaxModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SmartaxModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SmartaxPointsEntryModel::class => PointModel::class,
        SmartaxLocationEntryModel::class => LocationModel::class,
        SmartaxMeasurementEntryModel::class => MeasurementModel::class,
        SmartaxRelationEntryModel::class => RelationModel::class,
        SmartaxSegmentationEntryModel::class => SegmentationModel::class,
        SmartaxBboxEntryModel::class => BboxModel::class,
        SmartaxDetectedEntryModel::class => DetectedModel::class,
        SmartaxTaxationEntryModel::class => TaxationModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PointRepositoryInterface::class => PointRepository::class,
        LocationRepositoryInterface::class => LocationRepository::class,
        MeasurementRepositoryInterface::class => MeasurementRepository::class,
        RelationRepositoryInterface::class => RelationRepository::class,
        SegmentationRepositoryInterface::class => SegmentationRepository::class,
        BboxRepositoryInterface::class => BboxRepository::class,
        DetectedRepositoryInterface::class => DetectedRepository::class,
        TaxationRepositoryInterface::class => TaxationRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
