"use strict";

import "ol/ol.css"
import Map from "ol/Map";
import TileLayer from "ol/layer/Tile";
import OSM from "ol/source/OSM";
import View from "ol/View"
import { fromLonLat } from "ol/proj"

var map = new Map({
    target: 'list-map',
    layers: [
        new TileLayer({
            source: new OSM()
        })
    ],
    view: new View({
        center: fromLonLat([28.798709781914212, 41.10287155927904]),
        zoom: 12
    })
});

const conn = {
    serviceUrl: "https://geo.mapilio.com/geoserver/mapilio/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=mapilio:",
    street:{
        get url() {
            return conn.serviceUrl + "smartax_basaksehiryol&maxFeatures=500&outputFormat=application%2Fjson" + this.props;
        },
        rel : "mahalle_id",
        mapRel : "mahalle_id",
        props: "&CQL_FILTER=",
        field: ["yol_adi"],
        stroke: [38, 198, 218, .75],
        hoverStroke: '#8950FC',
        width: 5,
        id: "yol_id"
    },
    road:{
        get url() {
            return conn.serviceUrl + "smartax_basaksehiryol&maxFeatures=500&outputFormat=application%2Fjson"+this.props;
        },
        props: "&CQL_FILTER=",
        rel: "mahalle_id",
        mapRel: "objectid",
        field: ["yol_adi"],
        stroke: [38, 198, 218, .75],
        hoverStroke: '#8950FC',
        width: 6,
        id: "yol_id"
    },
    door:{
        get url() {
            return conn.serviceUrl + "smartax_basaksehirkapi&maxFeatures=500&outputFormat=application%2Fjson"+this.props;
        },
        props: "&CQL_FILTER=",
        rel: "yol_id",
        mapRel: "objectid",
        field: ["kapi_no","site_adi"],
        id: "objectid",
    },
    allDoors:{
        get url() {
            return conn.serviceUrl + "smartax_basaksehirkapi&maxFeatures=500&outputFormat=application%2Fjson"+this.props;
        },
        props: "&CQL_FILTER=",
        rel: "yol_id",
        mapRel: "yol_id",
        field: ["kapi_no","site_adi"],
        id: "objectid",
    },
    firstRoad: true,
    startingPoint : {
        field: ["adi_numara"],
        id: "objectid",
        get url() {
            return conn.serviceUrl + "smartax_basaksehirmahalle&maxFeatures=500&outputFormat=application%2Fjson"
        },
    }
}

export default { map, conn }
