$(function () {

    $.each($('.crop-image'), function (i,v) {
        var image = $(this)
        var index = image.data('index');
        var canvasSize = null;
        console.log('picture-frame-' + index)
        var pictureContainer = $('.picture-frame-' + index);
        var maxPictureContainerHeight = parseFloat(pictureContainer.css('max-height')) || "auto";

        // Wall is in Cm, convert to Inches to work out pixel sizes at 300dpi
        var wallWpx = (0.393700787 * pictureContainer.attr('data-width')) * 300; // data-width is the wall width in pixels
        var wallHpx = (0.393700787 * pictureContainer.attr('data-height')) * 300; // data-height is the wall height in pixels

        var sampleImageScaleFactor = (image.attr('width') / image.attr('original-width'));

        var wallSize = {
            width: wallWpx * sampleImageScaleFactor, // scaling the wall size corresponding the sample size
            height: wallHpx * sampleImageScaleFactor,
            originalWidth: pictureContainer.attr('data-width'),
            originalHeight: pictureContainer.attr('data-height')
        };
        var wallAspectRatio = wallSize.originalWidth / wallSize.originalHeight;

        var pictureContainerSizes = {
            'width': "100%",
            'height': maxPictureContainerHeight / (wallAspectRatio > 1 ? wallAspectRatio : 1)
        };

        pictureContainer.css(pictureContainerSizes).removeClass('hidden');
        var biggerSide = null;

        image.cropper({
            strict: true,
            background: false,
            guides: false,
            autoCropArea: 0.6,
            rotatable: false,
            zoomable: false,
            responsive: false,
            restore: true,
            viewMode: 2,
        });

        // Event
        image.on('built.cropper', function () {
            image.cropper('setCropBoxData', {
                left: 0,
                top: 0,
                width: pictureContainerSizes.width,
                height: pictureContainerSizes.height
            });
            canvasSize = {
                width: image.cropper('getCropBoxData').width,
                height: image.cropper('getCropBoxData').height
            };
            biggerSide = canvasSize.width === image.cropper('getImageData').width ? 'width' : 'height';

            var savedCropperSettings = {
                sliceW: parseFloat($('input[name=sliceW]').val()),
                sliceH: parseFloat($('input[name=sliceH]').val()),
                sliceX: parseFloat($('input[name=sliceX]').val()),
                sliceY: parseFloat($('input[name=sliceY]').val()),
                scale: parseFloat($('input[name=scale]').val()) // saved adoptedZoomFactor
            };

            if (!savedCropperSettings.scale) {
                return;
            }

            /* restoring saved settings */
            image.cropper('zoomTo', canvasSize[biggerSide] / (wallSize[biggerSide] / savedCropperSettings.scale.toFixed(1)));

            var cropboxData = image.cropper('getCropBoxData');
            var scaleFactor = wallSize.originalHeight / cropboxData.height;
            image.cropper('setCanvasData', {
                left: savedCropperSettings.sliceX / scaleFactor + cropboxData.left,
                top: savedCropperSettings.sliceY / scaleFactor + cropboxData.top
            });
        });

        var adoptedZoomFactor = NaN;
        var adoptedZoomElement = $('#adoptedZoom');
        image.on('crop.cropper', function () {
            var data = image.cropper('getData');
            var canvasData = image.cropper('getCanvasData');
            var cropboxData = image.cropper('getCropBoxData');
            var scaleFactor = wallSize.originalHeight / cropboxData.height;
            adoptedZoomFactor = parseFloat((wallSize[biggerSide] / data[biggerSide]).toFixed(2));
            adoptedZoomElement.text(adoptedZoomFactor);

            $('input[name=sliceW]').val(canvasData.width * scaleFactor);
            $('input[name=sliceH]').val(canvasData.height * scaleFactor);
            $('input[name=sliceX]').val((canvasData.left - cropboxData.left) * scaleFactor);
            $('input[name=sliceY]').val(canvasData.top * scaleFactor);
            $('input[name=scale]').val(adoptedZoomFactor);

        });
    });

});