$(function () {
    var cropData = {}
    var detail_id = $('.taxpayer-edit').data('id');
    //Get Detail
    var details = crudX({
        url: 'http://smartax.test/points/detail/' + detail_id,
        type: 'GET',
        success: function (relations) {
            //Set Detail
            var points_data = relations[relations.length - 1]

            $('input[name="area"]').val(Math.round(points_data.area) + " m²")
            $('input[name="coordinate"]').val(points_data.lat + ", " + points_data.lon)
            $('input[name="captured_at"]').val(moment(points_data.bbox.detail.stamp).lang("tr").format('DD MMMM YYYY - HH:mm'));
            $('iframe[name="street-view"]').attr('src', 'https://www.google.com/maps/embed?pb=!4v1553797194458!6m8!1m7!1sR4K_5Z2wRHTk9el8KLTh9Q!2m2!1d' + points_data.lat + '!2d' + points_data.lon + '!3f305.15097!4f0!5f0.7820865974627469');

            //Set Image
            $.each(relations, function (i, relation) {

                var real_bbox = {
                    x_min: relation.bbox.x_min,
                    y_min: relation.bbox.y_min,
                    x_max: relation.bbox.x_max,
                    y_max: relation.bbox.y_max,
                    height: parseInt(relation.bbox.y_max) - parseInt(relation.bbox.y_min),
                    width: parseInt(relation.bbox.x_max) - parseInt(relation.bbox.x_min),
                };

                var render_bbox = {
                    left: (real_bbox.x_min > 100) ? 100 : 0,
                    top: (real_bbox.y_min > 100) ? 100 : 0,
                    width: ((8192 - real_bbox.x_max) > 100) ? 100 : 8192 - real_bbox.x_max,
                    height: ((4096 - real_bbox.y_max) > 100) ? 100 : 4096 - real_bbox.y_max,
                };

                var crop_bbox = {
                    xmin: parseInt(real_bbox.x_min) - render_bbox.left,
                    ymin: parseInt(real_bbox.y_min) - render_bbox.top,
                    xmax: parseInt(real_bbox.x_max) + render_bbox.width,
                    ymax: parseInt(real_bbox.y_max) + render_bbox.height
                };

                var pano_detail = relation.bbox.detail;

                var img_url = 'https://image.mapilio.com/api/extract/?src=h:/'
                    + pano_detail.dirname + '/' + pano_detail.filename + '/' + pano_detail.imgname +
                    "&xmax=" + crop_bbox.xmax + "&xmin=" + crop_bbox.xmin + "&ymax=" + crop_bbox.ymax + "&ymin="
                    + crop_bbox.ymin;

                $('.picture-frame-' + i + ' > .crop-image').attr('src', img_url);

                if ((relations.length - 1) == i) {
                    $('.detail-image').attr('src', img_url);
                }


                cropData[i] = {
                    left: render_bbox.left,
                    top: render_bbox.top,
                    height: real_bbox.height,
                    width: real_bbox.width,
                };
                console.log(real_bbox, render_bbox, crop_bbox)
            })
        }
    });

    details.then(function () {
        $.each($('.crop-image'), function (i, v) {
            var image = $(this)

            image.cropper({
                strict: false,
                background: false,
                guides: false,
                rotatable: false,
                zoomable: false,
                responsive: false,
                restore: true,
                // viewMode: 2,
            });

            // Event
            image.on('built.cropper', function () {
                image.cropper('setCropBoxData', cropData[i]);
            });

            //Bu alan hesaplamada açılacak.
            // image.on('crop.cropper', function () {
            //     // var data = image.cropper('getData');
            //     // var canvasData = image.cropper('getCanvasData');
            //     var cropboxData = image.cropper('getCropBoxData');
            //     console.log(cropboxData)
            // });

        });


        //detail
        var detail_image = $('.detail-image');

        detail_image.cropper({
            strict: false,
            background: false,
            guides: false,
            rotatable: false,
            zoomable: false,
            responsive: false,
            restore: true,
        });

        detail_image.on('built.cropper', function () {
            console.log(cropData)
            detail_image.cropper('setCropBoxData', cropData[Object.keys(cropData)[Object.keys(cropData).length - 1]]);
            detail_image.cropper('disable');
        });

        detail_image.cropper.disabled();
    })
});