let errorAjax = true;
let loader;

$(function () {
    loader = showLoader();
    var cropData = {}, points_data;

    //Get Detail
    var detail_id = $('.taxpayer-detail').data('id');
    var details = crudX({
        url: '/api/smartax/detail/' + detail_id,
        type: 'GET',
        success: function (feature) {
            let coord = [feature.lon, feature.lat];
            let bbox_entries = feature.bbox_entries[Object.keys(feature.bbox_entries).length - 1];
            let point = feature.bbox_entries[Object.keys(feature.bbox_entries).length - 1];

            let resolution = point.resolution.split('x');
            let resolution_width = resolution[0];  //8192
            let resolution_height = resolution[1];  //4096

            var real_bbox = {
                x_min: bbox_entries.x_min,
                y_min: bbox_entries.y_min,
                x_max: bbox_entries.x_max,
                y_max: bbox_entries.y_max,
                height: parseInt(bbox_entries.y_max) - parseInt(bbox_entries.y_min),
                width: parseInt(bbox_entries.x_max) - parseInt(bbox_entries.x_min),
            };

            var render_bbox = {
                left: (real_bbox.x_min > 100) ? 100 : 0,
                top: (real_bbox.y_min > 100) ? 100 : 0,
                width: ((resolution_width - real_bbox.x_max) > 100) ? 100 : resolution_width - real_bbox.x_max,
                height: ((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max,
            };

            var crop_bbox = {
                xmin: parseInt(real_bbox.x_min) - render_bbox.left,
                ymin: parseInt(real_bbox.y_min) - render_bbox.top,
                xmax: parseInt(real_bbox.x_max) + render_bbox.width,
                ymax: parseInt(real_bbox.y_max) + render_bbox.height
            };

            $('[data-column="area"]').html(parseFloat(feature.area).toFixed(2) + " m²")
            $('[data-column="coordinate"]').html(feature.lat + ", " + feature.lon)
            $('[data-column="point"]').html("%" + parseInt(feature.confidence * 100).toFixed(0))
            $('[data-column="captured_at"]').html(moment(point.capture_time).lang("tr").format('DD MMMM YYYY HH:mm'));
            $('[data-column="updated_at"]').html(moment(feature.updated_at).lang("tr").format('DD MMMM YYYY HH:mm'));
            $('[data-column="calculated_price"]').html(parseFloat((parseFloat(feature.area).toFixed(2) * 70)).toFixed(2) + " ₺");
            $('iframe[name="map-view"]').attr('src', 'https://mapilio.com/embed?project_key=787lTPy6cA&class_code=inst-sign-store&center=' + coord.join(',') + '&feature_id=' + detail_id);
            loader.close();

            if (feature.taxpayer_id) {
                $('[data-column="name"]').html(feature.name);
                getTaxpayers(feature.taxpayer_id).then((r) => {
                    console.log(r.data,123,feature.taxpayer_id)
                    $('[data-column="vergino"]').html(r.data.taxnumber);
                    $('[data-column="kimlikno"]').html(r.data.identity_number);
                });
            }

            let value_neighborhood = feature.neighborhood_id;
            let value_road = feature.road_id;
            let value_number = feature.number_id;

            new Promise(function (callback) {
                getNeighborhood(value_neighborhood).then((r) => {
                    $('.neighborhood').html(r.data.name);
                    getRoads(value_road).then((r) => {
                        $('.road').html(r.data.name);
                        getNumbers(value_number).then((r) => {
                            $('.number').html(r.data.name);
                            callback(true);
                        });
                    });
                });
            }).then(() => {
                let address = $(".neighborhood").text() + " Mahallesi ";
                address += $(".road").text() + " Kapı No: ";
                address += $(".number").text();

                $('.address').html(address);
            });

            var img_url = 'https://cdn.mapilio.com/v2/im/extract/'
                + point.uploaded_hash + '/' + point.filename + '/'
                + crop_bbox.xmax + "/" + crop_bbox.ymax + "/" + crop_bbox.xmin + "/"
                + crop_bbox.ymin + '/' + (real_bbox.height + ((real_bbox.x_min > 100) ? 100 : 0) + (((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max));

            $('.crop-image').attr('src', img_url);


            cropData = {
                x: render_bbox.left,
                y: render_bbox.top,
                height: real_bbox.height,
                width: real_bbox.width,
            };
        },
        error: function () {
            Swal.fire({
                allowOutsideClick: false,
                title: 'Detay bilgisine ulaşılamadı!',
                text: "Tekrar denemek için lütfen pencereyi yenileyiniz.",
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Geri Dön'
            }).then((result) => {
                if (result.isConfirmed) {
                    location.href = '/admin/smartax/map';
                }
            })
        }
    });

    details.then(function () {
        var image = $('.crop-image')

        image.cropper({
            strict: false,
            background: false,
            guides: false,
            rotatable: false,
            zoomable: false,
            responsive: false,
            restore: true,
        });

        image.on('built.cropper', function () {
            image.cropper('setData', cropData);
            image.cropper('disable');
        });

        image.cropper.disabled();
    });
});

function getNeighborhood(id) {
    return $.ajax({
        url: '/api/smartax/get-neighborhoods/',
        data: {'id': id},
        type: 'GET',
        error: function () {
            errorS();
        }
    });
}

function getRoads(neighborhood_id) {
    return $.ajax({
        url: '/api/smartax/get-roads',
        type: 'GET',
        data: {'id': neighborhood_id},
        error: function () {
            errorS();
        }
    });
}

function getNumbers(road_id) {
    return $.ajax({
        url: '/api/smartax/get-numbers',
        type: 'GET',
        data: {'id': road_id},
        error: function () {
            errorS();
        }
    });
}

function getTaxpayers(number_id) {
    return $.ajax({
        url: '/api/smartax/get-taxpayers',
        type: 'GET',
        data: {'id': number_id},
        error: function () {
            errorS();
        }
    });
}

function showLoader() {
    return Swal.fire({
        imageUrl: loading_url,
        allowOutsideClick: false,
        showConfirmButton: false,
        imageWidth: 200,
        imageHeight: 200,
    });
}