<?php namespace Visiosoft\SmartaxModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;
use Visiosoft\SmartaxModule\Point\PointRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxPointsEntryModel;
use Visiosoft\SmartaxModule\Point\PointModel;
use Visiosoft\SmartaxModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\SmartaxModule\Location\LocationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxLocationEntryModel;
use Visiosoft\SmartaxModule\Location\LocationModel;
use Visiosoft\SmartaxModule\Measurement\Contract\MeasurementRepositoryInterface;
use Visiosoft\SmartaxModule\Measurement\MeasurementRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxMeasurementEntryModel;
use Visiosoft\SmartaxModule\Measurement\MeasurementModel;
use Visiosoft\SmartaxModule\Relation\Contract\RelationRepositoryInterface;
use Visiosoft\SmartaxModule\Relation\RelationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxRelationEntryModel;
use Visiosoft\SmartaxModule\Relation\RelationModel;
use Visiosoft\SmartaxModule\Segmentation\Contract\SegmentationRepositoryInterface;
use Visiosoft\SmartaxModule\Segmentation\SegmentationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxSegmentationEntryModel;
use Visiosoft\SmartaxModule\Segmentation\SegmentationModel;
use Visiosoft\SmartaxModule\Bbox\Contract\BboxRepositoryInterface;
use Visiosoft\SmartaxModule\Bbox\BboxRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxBboxEntryModel;
use Visiosoft\SmartaxModule\Bbox\BboxModel;
use Visiosoft\SmartaxModule\Detected\Contract\DetectedRepositoryInterface;
use Visiosoft\SmartaxModule\Detected\DetectedRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxDetectedEntryModel;
use Visiosoft\SmartaxModule\Detected\DetectedModel;
use Visiosoft\SmartaxModule\Taxation\Contract\TaxationRepositoryInterface;
use Visiosoft\SmartaxModule\Taxation\TaxationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxTaxationEntryModel;
use Visiosoft\SmartaxModule\Taxation\TaxationModel;
use Illuminate\Routing\Router;

class SmartaxModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/smartax/points'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@index',
        'admin/smartax/points/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@create',
        'admin/smartax/points/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@edit',
        'admin/smartax/location'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@index',
        'admin/smartax/list'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@list',
        'admin/smartax/location/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@create',
        'admin/smartax/location/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@edit',
        'admin/smartax/measurement'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\MeasurementController@index',
        'admin/smartax/measurement/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\MeasurementController@create',
        'admin/smartax/measurement/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\MeasurementController@edit',
        'admin/smartax/relation'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\RelationController@index',
        'admin/smartax/relation/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\RelationController@create',
        'admin/smartax/relation/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\RelationController@edit',
        'admin/smartax/segmentation'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SegmentationController@index',
        'admin/smartax/segmentation/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SegmentationController@create',
        'admin/smartax/segmentation/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SegmentationController@edit',
        'admin/smartax/bbox'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\BboxController@index',
        'admin/smartax/bbox/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\BboxController@create',
        'admin/smartax/bbox/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\BboxController@edit',
        'admin/smartax/detected'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\DetectedController@index',
        'admin/smartax/detected/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\DetectedController@create',
        'admin/smartax/detected/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\DetectedController@edit',
        // Admin TaxationController
        'admin/smartax'           => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@index',
        'admin/smartax/create'    => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@create',
        'admin/smartax/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@edit',

        // Admin LocationController
        'admin/location' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxationController@edit',
        'admin/smartax/report' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@report',
        'api/smartax/points' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\LocationController@points',

        // Taxpayer Controller
        'admin/taxpayer/detail/{id}' => [
            'as' => 'visiosoft.module.smartax::taxpayer_detail',
            'uses' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxpayerController@detail',
        ],
        'admin/taxpayer/edit/{id}' => [
            'as' => 'visiosoft.module.smartax::taxpayer_edit',
            'uses' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\TaxpayerController@edit',
        ],

        //Ajax Services
        'points/detail/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@detail',
        'api/set-point/{id}' => [
            'as' => 'visiosoft.module.smartax::api.set_point',
            'middleware' => [
                'auth'
            ],
            'uses' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\PointsController@setPointApi',
        ],
    ];

    protected $bindings = [
        SmartaxPointsEntryModel::class => PointModel::class,
        SmartaxLocationEntryModel::class => LocationModel::class,
        SmartaxMeasurementEntryModel::class => MeasurementModel::class,
        SmartaxRelationEntryModel::class => RelationModel::class,
        SmartaxSegmentationEntryModel::class => SegmentationModel::class,
        SmartaxBboxEntryModel::class => BboxModel::class,
        SmartaxDetectedEntryModel::class => DetectedModel::class,
        SmartaxTaxationEntryModel::class => TaxationModel::class,
    ];

    protected $singletons = [
        PointRepositoryInterface::class => PointRepository::class,
        LocationRepositoryInterface::class => LocationRepository::class,
        MeasurementRepositoryInterface::class => MeasurementRepository::class,
        RelationRepositoryInterface::class => RelationRepository::class,
        SegmentationRepositoryInterface::class => SegmentationRepository::class,
        BboxRepositoryInterface::class => BboxRepository::class,
        DetectedRepositoryInterface::class => DetectedRepository::class,
        TaxationRepositoryInterface::class => TaxationRepository::class,
    ];
}
