<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Visiosoft\SmartaxModule\Location\Form\LocationFormBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;

class LocationController extends AdminController
{
    public function index()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.location.title');

        if (request()->view === 'vertical') {
            return view('module::admin/location/index-2');
        } else {
            return view('module::admin/location/index');
        }
    }

    public function create(LocationFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(LocationFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function report()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.taxation.title');
        $this->breadcrumbs->add('Rapor Oluştur', '#');

        return view('module::admin.location.report');
    }

    public function list()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.taxation.title');
        $this->breadcrumbs->add('Tabela Listesi', '#');

        return view('module::admin.location.list');
    }

    public function points(PointRepositoryInterface $pointRepository)
    {
        $page = request()->all();

        $points = $pointRepository->newQuery();

        $filterables = array_filter($page['columns'], function ($column) {
            return $column['search']['value'];
        });

        foreach ($filterables as $filterable) {
            if ($filterable['data'] === 'id') {
                $points = $points->where('id', $filterable['search']['value']);
            } elseif ($filterable['data'] === 'formatted_created_at') {
                $dates = explode('|', $filterable['search']['value']);
                if ($dates[0]) {
                    $points = $points->whereDate('created_at', '>=', $dates[0]);
                }

                if ($dates[1]) {
                    $points = $points->whereDate('created_at', '<=', $dates[1]);
                }
//                dd($points->get());
            }
        }

        if (isset($page['order'])) {
            $order = $page['order'][0];

            $colExists = $pointRepository
                ->getModel()
                ->getConnection()
                ->getSchemaBuilder()
                ->hasColumn($pointRepository->getModel()->getTable(), $page['columnsDef'][$order['column']]);

            if ($colExists) {
                $points = $points->orderBy($page['columnsDef'][$order['column']], $order['dir']);
            }
        }

        $points = $points->paginate(
            $page['length'],
            ['*'],
            'page',
            $page['start'] / $page['length'] + 1
        );

        foreach ($points as $point) {
            $point->formatted_created_at = $point->created_at->format('d.m.Y');
        }

        return [
            "meta" => [
                "page" => $points->currentPage(),
                "pages" => $points->lastPage(),
                "perpage" => $page['length'],
                "total" => $points->total(),
                "sort" => "desc",
                "field" => "id"
            ],
            "data" => $points->items(),
            "recordsFiltered" => $points->total(),
            "recordsTotal" => $pointRepository->count(),
        ];
    }
}
