<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Support\Facades\DB;
use Visiosoft\SmartaxModule\Bbox\Contract\BboxRepositoryInterface;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;

class PointsController extends AdminController
{
    protected $points;
    protected $bbox;

    public function __construct(PointRepositoryInterface $pointRepository, BboxRepositoryInterface $bboxRepository)
    {
        $this->points = $pointRepository;
        $this->bbox = $bboxRepository;
        parent::__construct();
    }

    public function detail($id)
    {
        $detail = $this->points->newQuery()
            ->where('smartax_points.id', $id)
            ->leftJoin('smartax_relation', 'smartax_points.match_id', 'smartax_relation.match_id')
            ->limit(2)
            ->get();

        foreach ($detail as $index => $relation) {
            $bbox = $this->bbox->newQuery()->where('obj_id', $relation['obj_id'])->first();
            $bbox->images = "";
            $image = DB::table('basakpano')->where('id', $bbox->pano_id)
                ->selectRaw("dirname || '\' || filename || '\' || imgname AS image_url")->first();
            if(isset($image->image_url))
            {
                $bbox->images = $image->image_url;
            }
            $detail[$index]->bbox = $bbox;
        }

        return response()->json($detail);
    }
}
