<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Visiosoft\SmartaxModule\Location\Form\LocationFormBuilder;
use Visiosoft\SmartaxModule\Location\Table\LocationTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class LocationController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param LocationTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(LocationTableBuilder $table)
    {
        return $this->view->make('module::admin/location/index');
    }

    /**
     * Create a new entry.
     *
     * @param LocationFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(LocationFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param LocationFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(LocationFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function report()
    {
        return view('module::admin.location.report');
    }
}
