$(function () {
    var cropData = {}
    //Get Detail
    var details = crudX({
        url: 'http://smartax.test/points/detail/1',
        type: 'GET',
        success: function (relations) {
            //Set Image
            $.each(relations, function (i, relation) {

                var real_bbox = {
                    x_min: relation.bbox.x_min,
                    y_min: relation.bbox.y_min,
                    x_max: relation.bbox.x_max,
                    y_max: relation.bbox.y_max,
                    height: parseInt(relation.bbox.y_max) - parseInt(relation.bbox.y_min),
                    width: parseInt(relation.bbox.x_max) - parseInt(relation.bbox.x_min),
                };

                var render_bbox = {
                    left: (real_bbox.x_min > 100) ? 100 : 0,
                    top: (real_bbox.y_min > 100) ? 100 : 0,
                    width: ((8192 - real_bbox.x_max) > 100) ? 100 : 8192 - real_bbox.x_max,
                    height: ((4096 - real_bbox.y_max) > 100) ? 100 : 4096 - real_bbox.y_max,
                };

                var crop_bbox = {
                    xmin: parseInt(real_bbox.x_min) - render_bbox.left,
                    ymin: parseInt(real_bbox.y_min) - render_bbox.top,
                    xmax: parseInt(real_bbox.x_max) + render_bbox.width,
                    ymax: parseInt(real_bbox.y_max) + render_bbox.height
                };

                var img_url = 'https://image.mapilio.com/api/extract/?src=h:/'
                    + relation.bbox.images +
                    "&xmax=" + crop_bbox.xmax + "&xmin=" + crop_bbox.xmin + "&ymax=" + crop_bbox.ymax + "&ymin="
                    + crop_bbox.ymin;

                $('.picture-frame-' + i + ' > .crop-image').attr('src', img_url);


                cropData[i] = {
                    left: render_bbox.left,
                    top: render_bbox.top,
                    height: real_bbox.height,
                    width: real_bbox.width,
                };
                console.log(real_bbox,render_bbox,crop_bbox)
            })
        }
    });

    details.then(function () {
        $.each($('.crop-image'), function (i, v) {
            var image = $(this)

            image.cropper({
                strict: false,
                background: false,
                guides: false,
                rotatable: false,
                zoomable: false,
                responsive: false,
                restore: true,
                // viewMode: 2,
            });

            // Event
            image.on('built.cropper', function () {
                image.cropper('setCropBoxData', cropData[i]);
            });

            //Bu alan hesaplamada açılacak.
            // image.on('crop.cropper', function () {
            //     // var data = image.cropper('getData');
            //     // var canvasData = image.cropper('getCanvasData');
            //     var cropboxData = image.cropper('getCropBoxData');
            //     console.log(cropboxData)
            // });

        });
    })
});