import { Vector as SourceVector } from "ol/source";
import { GeoJSON } from "ol/format";
import { Style, Icon, Stroke, Fill } from "ol/style";
import { Vector as LayerVector } from "ol/layer";

import map from "./list-map"

var expandedVector, vectorSource;
import pin from './images/pin.svg'

const drawOnMap = (
    url,
    fill = [213, 0, 0, .5],
    stroke = "#9E0303",
    strokeWidth = 1,
    hoverFill = '#8E1522',
    hoverStroke = '#8E1522'
) => {
    if (expandedVector) {
        map.map.removeLayer(expandedVector);
    }

    vectorSource = new SourceVector({
        // url: "http://10.10.5.49:3040/geoserver/mapilio/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=mapilio%3ABasaksehirMahalle&maxFeatures=50&outputFormat=application%2Fjson&CQL_FILTER=objectid=1",
        // url: "http://10.10.5.49:3040/geoserver/mapilio/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=mapilio%3ABasaksehirKapi&maxFeatures=500&outputFormat=application%2Fjson&CQL_FILTER=yol_id=1055",
        url : url,
        format: new GeoJSON(),
    });

    function styleMe(feature) {
        let style;
        if (feature.getGeometry().getType() == "Point"){
            style = new Style({
                image: new Icon({
                    src: pin
                })
            })
        } else {
            style = new Style({
                fill: new Stroke({
                    color: fill
                }),
                stroke: new Stroke({
                    color: stroke,
                    width: strokeWidth
                })
            });
        }
        return style;
    }

    expandedVector = new LayerVector({
        source: vectorSource,
        style: styleMe,
        title: "expandedSearch"
    });

    map.map.addLayer(expandedVector);

    var highlightStyle = new Style({
        fill: new Stroke({
            color: hoverFill
        }),
        stroke: new Stroke({
            color: hoverStroke,
            width: strokeWidth
        }),
        zIndex: 100,
    })
    var selected = null;
    map.map.on('pointermove', function (e) {
        if (selected !== null) {
            selected.setStyle(undefined);
            selected = null;
        }

        map.map.forEachFeatureAtPixel(e.pixel, function (f) {
            selected = f;
            if (f.getGeometry().getType() !== "Point") {
                f.setStyle(highlightStyle);
            }
            return true;
        });
    });

    global.expandedVector = expandedVector;

    var listenerKey = vectorSource.on('addfeature', function(e) {
        if (vectorSource.getState() == 'ready') {
            map.map.getView().fit(vectorSource.getExtent(), {size: map.map.getSize(), maxZoom: 19});
            // ol_observable.unByKey(listenerKey);
        }
    });
}

map.map.on("singleclick", function (evt) {
    this.forEachFeatureAtPixel(evt.pixel, function (feature, layer) {
        console.log(feature)

        const featureID = feature.id_
        let type
        if (featureID.startsWith('smartax_basaksehirmahalle')) {
            type = 'street'
        } else if (featureID.startsWith('smartax_basaksehiryol')) {
            type = map.conn.firstRoad ? 'road' : 'allDoors'
            map.conn.firstRoad = false
        } else if (featureID.startsWith('smartax_basaksehirkapi')) {
            type = 'door'
        }

        if (type) {
            const params = map.conn[type]

            let urls = params.rel ? params.url + params.mapRel + "=" + feature.values_.objectid : params.url
            drawOnMap(urls, params.fill, params.stroke, params.width, params.hoverFill, params.hoverStroke)
        }
    });
});

export { drawOnMap }