<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSmartaxCreateLocationStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'location',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'lat' => [
            'required' => true,
        ],
        'lon' => [
            'required' => true,
        ],
        'classname' => [
            'required' => true,
        ],
        'score' => [
            'required' => true,
        ],
        'valid' => [
            'required' => true,
        ],
        'match_id' => [
            'required' => true,
            'unique' => true,
        ],
    ];

}
