<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSmartaxCreateMeasurementStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'measurement',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'match_id' => [
            'required' => true,
        ],
        'avg_width' => [
            'required' => true,
        ],
        'avg_height' => [
            'required' => true,
        ],
        'avg_area' => [
            'required' => true,
        ],
    ];

}
