<?php namespace Visiosoft\SmartaxModule\Commands;

use GuzzleHttp\Client;
use Visiosoft\SmartaxModule\SequenceDetail\Contract\SequenceDetailRepositoryInterface;

class SyncMapilioSequencesDetails
{
    protected $token;

    protected $limit;

    public function __construct($token, $limit = 3)
    {
        $this->token = $token;
        $this->limit = $limit;
    }

    public function handle(
        SequenceDetailRepositoryInterface $repository
    )
    {
        $count = 0;
        // Get Sequences With CURL Service
        $entries = $repository->newQuery()
            ->where('sync_detail', false)
            ->orderBy('id')
            ->limit($this->limit)
            ->get();


        // Save Sequence
        foreach ($entries as $entry) {
            $detail = $this->getSequenceDetail($entry->sequence_uuid);

            if ($detail) {
                $entry->update([
                    'count' => $detail['count'],
                    'size' => $detail['size'],
                    'anomaly' => $detail['anomaly'],
                    'length_km' => $detail['length_km'],
                    'sync_detail' => true,
                ]);

                $count++;
            }
        }

        return [
            'counter' => $count
        ];
    }

    public function getSequenceDetail($uuid)
    {
        $detail = $this->newRequest($this->token, $uuid);

        if (isset($detail['data'])) {
            return $detail['data'];
        }

        return null;
    }

    public function newRequest($token, $uuid)
    {
        try {
            $url = setting_value('visiosoft.module.smartax::mapilio_sync_url') . "/api/sequence/sequence" . '?' . http_build_query([
                    'token' => $token,
                    'sequence_uuid' => $uuid
                ]);

            $client = new Client([
                'cookies' => true,
                'http_errors' => false,
                'verify' => false
            ]);

            $response = $client->request('GET', $url);

            $response = $response->getBody()->getContents();

            $response = json_decode($response, true);

            if (!$response['status']) {
                throw new \Exception([$response['message']]);
            }

            return $response['response'];

        } catch (\Exception $exception) {
            throw new \Exception(["The incoming data is not correct."]);
            die;
        }
    }
}