"use strict";
// Class definition

var KTDatatableLocalSortDemo = function () {
    // Private functions

    // basic demo
    var demo = function () {
        var datatable = $('#kt_datatable').KTDatatable({
            data: {
                type: 'remote',
                source: {
                    read: {
                        url: test_json,
                    },
                },
                pageSize: 10,
                serverPaging: false,
                serverFiltering: true,
                serverSorting: false,
                saveState: {
                    cookie: true,
                    webstorage: true,
                },
            },

            // layout definition
            layout: {
                scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
                footer: false, // display/hide footer
            },

            // column sorting
            sortable: true,

            pagination: true,

            search: {
                input: $('#kt_datatable_search_query'),
                key: 'generalSearch'
            },

            // columns definition
            columns: [{
                field: 'SERİ NO',
                title: 'SERİ NO',
                sortable: 'asc',
                width: 100,
                type: 'number',
                selector: false,
            }, {
                field: 'DÜKKAN ADI',
                title: 'DÜKKAN ADI',
                sortable: true
            }, {
                field: 'ALAN',
                title: 'ALAN',
            }, {
                field: 'TARİH',
                title: 'TARİH',
                type: 'date',
                format: 'DD/MM/YYYY',
            },
                {
                    field: 'MAHALLE',
                    title: 'MAHALLE',
                }, {
                    field: 'KAPI NO',
                    title: 'KAPI NO',
                }, {
                    field: 'VERGİ TUTARI',
                    title: 'VERGİ TUTARI',
                }, {
                    field: 'DURUM',
                    textAlign: 'center',
                    title: 'DURUM',
                    template: function (row) {
                        var status = {
                            0: {
                                'title': 'Onay Bekliyor',
                                'class': 'label-light-danger'
                            },
                            1: {
                                'title': 'Hesaplandı',
                                'class': ' label-light-success'
                            },
                            2: {
                                'title': 'İptal Edildi',
                                'class': ' label-light-warning'
                            }
                        };
                        return '<span class="label font-weight-bold label-lg w-75 ' + status[row.status].class + ' label-inline label-bold">' + status[row.status].title + '</span>';
                    },
                }],
        });
    };

    return {
        // public functions
        init: function () {
            demo();
            $('#date-1, #date-2').selectpicker();

        },
    };
}();

jQuery(document).ready(function () {
    KTDatatableLocalSortDemo.init();
});
