<?php namespace Visiosoft\SmartaxModule\User\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Anomaly\UsersModule\User\UserModel;

class UserTableBuilder extends TableBuilder
{
    protected $model = UserModel::class;

    public $actions = [
        'delete',
    ];

    protected $views = [];

    protected $columns = [
        'display_name',
        'email',
    ];

    protected $buttons = [
        'edit' => [
            'href' => 'admin/smartax/users/edit/{entry.id}'
        ],
    ];

    public function setTableEntries(\Illuminate\Support\Collection $entries)
    {
        $entries = $entries->filter(
            function ($user) {
                return $user->hasRole('smartax_admin') && $user->username != 'smartax';
            }
        );

        return parent::setTableEntries($entries);
    }

    public function onBuilt()
    {
        $this->table->setOption('total_results', null);
    }
}
