<?php namespace Visiosoft\SmartaxModule\User\Form;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Illuminate\Support\Str;

class UserFormHandler
{
    public function handle(UserFormBuilder $builder, RoleRepositoryInterface $roles)
    {
        if (!$builder->canSave()) {
            return;
        }

        if ($builder->getFormMode() == 'edit') {
            $entry = $builder->getFormEntry();
        } else {
            $entry = new \Anomaly\UsersModule\User\UserModel();
            $entry->setAttribute('username', Str::slug($builder->getPostValue('display_name') . strtotime('now')));
            $entry->setAttribute('activated', true);
            $entry->setAttribute('enabled', true);
        }

        $entry->setAttribute('email', $builder->getPostValue('email'));
        $entry->setAttribute('display_name', $builder->getPostValue('display_name'));

        if (request()->get('password')) {
            $entry->setAttribute('password', $builder->getPostValue('password'));
        };

        $entry->save();

        if ($builder->getFormMode() != 'edit') {
            $admin = $roles->findBySlug('smartax_admin');
            $entry->roles()->sync([$admin->getId()]);

            $builder->setFormEntry($entry);
        }
    }
}
