<?php namespace Visiosoft\SmartaxModule\Commands;

use Illuminate\Support\Facades\DB;

class getGeoRoads
{

    protected $filter_params;

    public function __construct($filter_params)
    {
        $this->filter_params = $filter_params;
    }

    public function handle()
    {
        try {
            $filter = $this->filter_params;
            $filter_query = "";
            if (!empty($filter['mahalle_id'])) {
                $filter_query = "where mahalle_id=" . $filter['mahalle_id'];
            } elseif (!empty($filter['objectid'])) {
                $filter_query = "where objectid=" . $filter['objectid'];
            }

            $query = "SELECT Row_to_json(fc) AS geojson
                    FROM   (SELECT 'FeatureCollection'         AS TYPE,
                                   Array_to_json(Array_agg(f)) AS FEATURES
                            FROM   (SELECT 'Feature'
                                           AS TYPE
                                           ,
                                           Json_build_object('objectid', LG.objectid,
                                           'yol_id'
                                           , LG.yol_id, 'yol_adi', LG.yol_adi, 'mahalle_id',
                                           LG.mahalle_id,
                                           'type','road',
                                           'mahalle_ad',
                                           LG.mahalle_ad)
                                           AS
                                           properties,
                                           St_asgeojson(St_transform(LG.geom, 4326), 15, 0) :: json
                                           AS
                                           GEOMETRY
                                    FROM   (SELECT objectid,
                                                   yol_id,
                                                   yol_adi,
                                                   mahalle_id,
                                                   mahalle_ad,
                                                   geom
                                            FROM   default_basaksehir_yol $filter_query) AS LG) AS F) AS FC;  ";

            $entries = DB::select($query);
            $entries = collect($entries);

            return $entries->first()->geojson;
        } catch (\Exception $exception) {
            return null;
        }
    }
}