<?php namespace Visiosoft\SmartaxModule\Commands;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\DB;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;

class SyncMapilioPoint
{
    protected $token;
    protected $project_key;
    protected $organization_key;

    public function __construct($token, $project_key, $organization_key)
    {
        $this->token = $token;
        $this->project_key = $project_key;
        $this->organization_key = $organization_key;
    }

    public function handle(
        PointRepositoryInterface $pointRepository
    )
    {
        $counter = 0;
        $skip = $pointRepository->newQuery()->count();

        // Get Points With CURL Service
        $points = $this->getPoints($skip);

        // Save Points
        foreach ($points as $item) {

            $is_points = $pointRepository->newQuery()
                ->where('photo_uuid', $item['photo_uuid'])
                ->first();

            if (!$is_points) {

                /**
                 * Save Point
                 */
                $point = $pointRepository->newQuery()
                    ->create([
                        'lat' => $item['lat'],
                        'lon' => $item['lon'],
                        'heading' => $item['heading'],
                        'altitude' => $item['altitude'],
                        'orientation' => $item['orientation'],
                        'filename' => $item['filename'],
                        'device_make' => $item['device_make'],
                        'device_model' => $item['device_model'],
                        'sequence_uuid' => $item['sequence_uuid'],
                        'uploaded_hash' => $item['uploaded_hash'],
                        'photo_uuid' => $item['photo_uuid'],
                        'resolution' => $item['resolution'],
                        'fov' => $item['fov'],
                        'anomaly' => $item['anomaly'],
                        'data_created_by_id' => $item['data_created_by_id'],
                        'capture_time' => $item['capture_time'],
                    ]);

                // Geom Save (Point)
                DB::statement("UPDATE default_smartax_point
	                                        SET  geom=ST_GeomFromGeoJSON('" . json_encode($item['geom']) . "')
	                                        WHERE id=" . $point->id . ";");

                $counter++;
            }
        }

        return [
            'counter' => $counter
        ];
    }

    public function getPoints($skip)
    {
        $points = $this->newRequest($this->token, $this->organization_key, $this->project_key, $skip);

        if (isset($points['data']) && count($points['data'])) {
            return $points['data'];
        }

        return [];
    }

    public function newRequest($token, $organization_key, $project_key, $skip = 0)
    {
        try {
            $url = setting_value('visiosoft.module.smartax::mapilio_sync_url') . "/api/points/list" . '?' . http_build_query([
                    'token' => $token,
                    'organization_key' => $organization_key,
                    'project_key' => $project_key,
                    'skip' => $skip
                ]);

            $client = new Client([
                'cookies' => true,
                'http_errors' => false,
                'verify' => false
            ]);

            $response = $client->request('GET', $url);

            $response = $response->getBody()->getContents();


            $response = json_decode($response, true);

            if (!$response['status']) {
                throw new \Exception([$response['message']]);
            }

            return $response['response'];

        } catch (\Exception $exception) {
            throw new \Exception(["The incoming data is not correct."]);
            die;
        }
    }
}