$(function () {
    var cropData = {}, points_data;

    //Get Detail
    var detail_id = $('.taxpayer-detail').data('id');
    var details = crudX({
        url: '/api/smartax/detail/' + detail_id,
        type: 'GET',
        success: function (feature) {

            let bbox_entries = feature.bbox_entries[Object.keys(feature.bbox_entries).length - 1];
            let point = feature.bbox_entries[Object.keys(feature.bbox_entries).length - 1].detail;

            let resolution = point.resolution.split('x');
            let resolution_width = resolution[0];  //8192
            let resolution_height = resolution[1];  //4096

            var real_bbox = {
                x_min: bbox_entries.x_min,
                y_min: bbox_entries.y_min,
                x_max: bbox_entries.x_max,
                y_max: bbox_entries.y_max,
                height: parseInt(bbox_entries.y_max) - parseInt(bbox_entries.y_min),
                width: parseInt(bbox_entries.x_max) - parseInt(bbox_entries.x_min),
            };

            var render_bbox = {
                left: (real_bbox.x_min > 100) ? 100 : 0,
                top: (real_bbox.y_min > 100) ? 100 : 0,
                width: ((resolution_width - real_bbox.x_max) > 100) ? 100 : resolution_width - real_bbox.x_max,
                height: ((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max,
            };

            var crop_bbox = {
                xmin: parseInt(real_bbox.x_min) - render_bbox.left,
                ymin: parseInt(real_bbox.y_min) - render_bbox.top,
                xmax: parseInt(real_bbox.x_max) + render_bbox.width,
                ymax: parseInt(real_bbox.y_max) + render_bbox.height
            };

            $('[data-column="area"]').html(parseFloat(feature.area).toFixed(2) + " m²")
            $('[data-column="coordinate"]').html(feature.lat + ", " + feature.lon)
            $('[data-column="point"]').html("%" + parseInt(feature.confidence * 100).toFixed(0))
            $('[data-column="captured_at"]').html(moment(point.capture_time).lang("tr").format('DD MMMM YYYY HH:mm'));
            $('[data-column="updated_at"]').html(moment(feature.updated_at).lang("tr").format('DD MMMM YYYY HH:mm'));
            $('[data-column="calculated_price"]').html(parseFloat((parseFloat(feature.area).toFixed(2) * 70)).toFixed(2) + " ₺");

            let value_district = feature.selected_district_id ? feature.selected_district_id : feature.detected_district_id;
            let value_street = feature.selected_road_id ? feature.selected_road_id : feature.detected_road_id;
            let value_door = feature.selected_door_id ? feature.selected_door_id : feature.detected_door_id;

            let properties = JSON.parse(feature.properties);

            if (properties && properties.hasOwnProperty('name')) {
                $('.name').html(properties.name);
            }

            new Promise(function (callback) {
                getDistrict(value_district).then((r) => {
                    $('.district').html(r.data.name);
                    getStreets(value_street).then((r) => {
                        $('.street').html(r.data.name);
                        getDoors(value_door).then((r) => {
                            $('.door').html(r.data.name);
                            callback(true);
                        });
                    });
                });
            }).then(() => {
                let address = $(".district").text() + " Mahallesi ";
                address += $(".street").text() + " Kapı No: ";
                address += $(".door").text();

                $('.address').html(address);
            });

            detailMap(detail_id, [feature.lat, feature.lon])


            var img_url = 'https://cdn.mapilio.com/v2/im/extract/'
                + point.uploaded_hash + '/' + point.filename + '/'
                + crop_bbox.xmax + "/" + crop_bbox.ymax + "/" + crop_bbox.xmin + "/"
                + crop_bbox.ymin + '/' + (real_bbox.height + ((real_bbox.x_min > 100) ? 100 : 0) + (((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max));

            $('.crop-image').attr('src', img_url);


            cropData = {
                x: render_bbox.left,
                y: render_bbox.top,
                height: real_bbox.height,
                width: real_bbox.width,
            };
        },
        error: function () {
            Swal.fire({
                allowOutsideClick: false,
                title: 'Detay bilgisine ulaşılamadı!',
                text: "Tekrar denemek için lütfen pencereyi yenileyiniz.",
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Tekrar Dene'
            }).then((result) => {
                if (result.isConfirmed) {
                    location.reload();
                }
            })
        }
    });

    details.then(function () {
        var image = $('.crop-image')

        image.cropper({
            strict: false,
            background: false,
            guides: false,
            rotatable: false,
            zoomable: false,
            responsive: false,
            restore: true,
        });

        image.on('built.cropper', function () {
            image.cropper('setData', cropData);
            image.cropper('disable');
        });

        image.cropper.disabled();
    });
});


function detailMap(title, coordinate) {
    var leaflet = new L.Map('detailMap', {zoom: 20, center: new L.latLng(coordinate)});

    leaflet.addLayer(new L.TileLayer('http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png'));

    L.control.scale().addTo(leaflet);

    var leafletIcon = L.divIcon({
        html: `<span class="svg-icon svg-icon-widget-purple svg-icon-3x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="24" width="24" height="0"/><path d="M5,10.5 C5,6 8,3 12.5,3 C17,3 20,6.75 20,10.5 C20,12.8325623 17.8236613,16.03566 13.470984,20.1092932 C12.9154018,20.6292577 12.0585054,20.6508331 11.4774555,20.1594925 C7.15915182,16.5078313 5,13.2880005 5,10.5 Z M12.5,12 C13.8807119,12 15,10.8807119 15,9.5 C15,8.11928813 13.8807119,7 12.5,7 C11.1192881,7 10,8.11928813 10,9.5 C10,10.8807119 11.1192881,12 12.5,12 Z" fill="#000000" fill-rule="nonzero"/></g></svg></span>`,
        bgPos: [20, 20],
        iconAnchor: [20, 37],
        popupAnchor: [0, -37],
        className: 'leaflet-marker'
    });

    var marker = L.marker(coordinate, {icon: leafletIcon}).addTo(leaflet);
    marker.bindPopup(title, {closeButton: false});
}

function getDistrict(id) {
    return $.ajax({
        url: '/api/smartax/get-districts/',
        data: {'id': id},
        type: 'GET',
        error: function () {
            errorS();
        }
    });
}

function getStreets(district_id) {
    return $.ajax({
        url: '/api/smartax/get-streets',
        type: 'GET',
        data: {'id': district_id},
        error: function () {
            errorS();
        }
    });
}

function getDoors(street_id) {
    return $.ajax({
        url: '/api/smartax/get-doors',
        type: 'GET',
        data: {'id': street_id},
        error: function () {
            errorS();
        }
    });
}