const filter = $('.filter-dd-wrapper')
const {drawOnMap, handleBreadcrumb, addMapParams} = require('./feature');
import map from "./list-map"

const expandedSearch = {
    searchParams: new URLSearchParams(window.location.search),

    queryLocation() {
        return {
            street: this.searchParams.get('street'),
            road: this.searchParams.get('road'),
        }
    },

    queryProcessed: {
        street: false,
        road: false,
    },

    getter(params, v, type) {
        if (type === 'road') {
            const types = ['road', 'allDoors']

            for (let i = 0; i < 2; i++) {
                const params = map.conn[types[i]]

                let urls = params.rel ? params.url + params.mapRel + "=" + v : params.url
                drawOnMap(urls, params.fill, params.stroke, params.width, params.hover, i === 0)
            }
        } else {
            let urls = params.rel ? params.url + params.mapRel + "=" + v : params.url
            drawOnMap(urls, params.fill, params.stroke, params.width, params.hover)
        }
    },
    ajaxRequest(params, i, v) {
        let url = params.rel ? params.url + params.rel + "=" + v : params.url;
        fetch(url).then(function (data) {
            return data.json()
        }).then(response => {
            expandedSearch.Lister(response, params, i)
        }).catch(function (error) {
            errorS();
        })
    },
    handleQuery() {
        if (this.queryLocation().street && !this.queryProcessed.street && $('.filter-dd-wrapper[data-name=street] .dropdown-item').length) {
            this.queryProcessed.street = true;

            $('.filter-dd-wrapper[data-name=street]').find(`[data-val=${this.queryLocation().street}]`).click()
        }

        if (this.queryLocation().road && !this.queryProcessed.road && $('.filter-dd-wrapper[data-name=road] .dropdown-item').length) {
            this.queryProcessed.road = true;

            $('.filter-dd-wrapper[data-name=road]').find(`[data-val=${this.queryLocation().road}]`).click()
        }
    },
    Lister(response, params, index) {
        filter.eq(index).find('.dropdown-menu').html('');

        filter.eq(index).find('.dropdown-menu').append(
            // data.filter(p=>p.src.split('.').pop() !== "json").map(p=>p.src);
            response.features.map(t => `
                <a class="dropdown-item py-2" data-val="${t.properties[params.id]}">
                    <span class="text-truncate">${params.field.map(fields => t.properties[fields])}</span>
                </a>
            `)
        );

        this.handleQuery()
    },
    init() {
        expandedSearch.ajaxRequest(map.conn.startingPoint, 0);
        filter.each(function (index, item) {
            filter.eq(index).on('click', '.dropdown-menu .dropdown-item', function () {
                $(this).addClass('active')
                    .siblings()
                    .removeClass('active')
                    .closest('.dropdown')
                    .find('.dropdown-toggle')
                    .addClass('active')
                    .find('span')
                    .text($(this).text())

                const nextDropdowns = $(this).closest('.filter-dd-wrapper')
                    .nextAll()
                    .find('.dropdown-toggle')
                    .removeClass('active')

                for (let dropdown of nextDropdowns) {
                    dropdown = $(dropdown)
                    const name = $(dropdown).closest('.filter-dd-wrapper').data('name')
                    if (name === 'road') {
                        $('span', dropdown).text('Sokak/Yol ara')
                    } else if (name === 'door') {
                        $('span', dropdown).text('Kapi No ara')
                    }
                }

                nextDropdowns.siblings('.dropdown-menu').html('')

                const ajaxIndex = index === 2 ? index - 1 : index

                if (index === 0) {
                    map.conn.firstRoad = true
                } else if (index === 1) {
                    map.conn.firstRoad = false
                }

                if (index !== 2) {
                    expandedSearch.ajaxRequest(
                        map.conn[filter.eq(ajaxIndex + 1).data('name')], ajaxIndex + 1, $(this).data('val')
                    )
                }

                /* Handle breadcrumb */
                const type = $(this).closest('.filter-dd-wrapper').data('name');
                if (['street', 'road'].includes(type)) {
                    const url = addMapParams(type, $(this).data('val'));
                    handleBreadcrumb(type, url);
                }
                /* End Handle breadcrumb */

                if (type == 'street') {
                    searchDistrict($(this).data('val'));
                } else if (type == 'road') {
                    searchRoad($(this).data('val'));
                } else if (type == 'door') {
                    searchDoor($(this).data('val'));
                }

                if (filter.eq(index).data('name') != 'door') {
                    expandedSearch.getter(
                        map.conn[filter.eq(index).data('name')],
                        $(this).data('val'),
                        filter.eq(index).data('name')
                    )
                }
            })
        });

        expandedSearch.getter(map.conn.startingPoint, 0, 'startingPoint')
    }
};

expandedSearch.init()

export default expandedSearch
