$(function () {

    $.each($('.crop-image'), function (i,v) {
        var image = $(this)
        var index = image.data('index');
        var canvasSize = null;
        var pictureContainer = $('.picture-frame-' + index);
        var maxPictureContainerHeight = parseFloat(pictureContainer.css('max-height')) || "auto";

        // Wall is in Cm, convert to Inches to work out pixel sizes at 300dpi
        var wallWpx = (0.393700787 * pictureContainer.attr('data-width')) * 300; // data-width is the wall width in pixels
        var wallHpx = (0.393700787 * pictureContainer.attr('data-height')) * 300; // data-height is the wall height in pixels

        var sampleImageScaleFactor = (image.attr('width') / image.attr('original-width'));

        var wallSize = {
            width: wallWpx * sampleImageScaleFactor, // scaling the wall size corresponding the sample size
            height: wallHpx * sampleImageScaleFactor,
            originalWidth: pictureContainer.attr('data-width'),
            originalHeight: pictureContainer.attr('data-height')
        };
        var wallAspectRatio = wallSize.originalWidth / wallSize.originalHeight;

        var pictureContainerSizes = {
            'width': "100%",
            'height': maxPictureContainerHeight / (wallAspectRatio > 1 ? wallAspectRatio : 1)
        };

        pictureContainer.css(pictureContainerSizes).removeClass('hidden');

        image.cropper({
            strict: true,
            background: false,
            guides: false,
            autoCropArea: 0.6,
            rotatable: false,
            zoomable: false,
            responsive: false,
            restore: true,
            viewMode: 2,
        });

        // Event
        image.on('built.cropper', function () {
            image.cropper('setCropBoxData', cropData[index]);
            canvasSize = {
                width: image.cropper('getCropBoxData').width,
                height: image.cropper('getCropBoxData').height
            };
        });

        image.on('crop.cropper', function () {
            var cropboxData = image.cropper('getCropBoxData');
            console.log(cropboxData)
        });
    });
});