<?php namespace Visiosoft\SmartaxModule\Commands;

use GuzzleHttp\Client;
use Visiosoft\SmartaxModule\SequenceDetail\Contract\SequenceDetailRepositoryInterface;

class SyncMapilioSequences
{
    protected $token;
    protected $project_key;
    protected $organization_key;

    public function __construct($token, $project_key, $organization_key)
    {
        $this->token = $token;
        $this->project_key = $project_key;
        $this->organization_key = $organization_key;
    }

    public function handle(
        SequenceDetailRepositoryInterface $repository
    )
    {
        // Get Sequences With CURL Service
        $sequences = $this->getSequences();


        // Save Sequence
        foreach ($sequences as $item) {
            if (!$repository->findBy('sequence_uuid', $item['sequence_uuid']))
                $repository->newQuery()->create(['sequence_uuid' => $item['sequence_uuid']]);
        }

        return [
            'counter' => count($sequences)
        ];
    }

    public function getSequences()
    {
        $sequences = $this->newRequest($this->token, $this->organization_key, $this->project_key);

        return $sequences;
    }

    public function newRequest($token, $organization_key, $project_key)
    {
        try {
            $url = setting_value('visiosoft.module.smartax::mapilio_sync_url') . "/api/sequence/sequences" . '?' . http_build_query([
                    'token' => $token,
                    'organization_key' => $organization_key,
                    'project_key' => $project_key
                ]);

            $client = new Client([
                'cookies' => true,
                'http_errors' => false,
                'verify' => false
            ]);

            $response = $client->request('GET', $url);

            $response = $response->getBody()->getContents();

            $response = json_decode($response, true);

            if (!$response['status']) {
                throw new \Exception([$response['message']]);
            }

            return $response['response'];

        } catch (\Exception $exception) {
            throw new \Exception(["The incoming data is not correct."]);
            die;
        }
    }
}