var pano_details = {};
var calculated = {};
var cropData = {};
var crop_bbox = {};
var detail_id = $('.taxpayer-edit').data('id');
var completed_calculation_job = false;
var mode = "calculate";
var detail_entry = null;
let deleted_entries = [];
let loading;

let errorAjax = true;

function setDetailAttribute() {
    let entry = detail_entry;
    let image = entry;
    let coord = [entry.lon,entry.lat];


    let resolution = image.resolution.split('x');
    let resolution_height = resolution[1];  //4096

    let real_bbox = {
        x_min: entry.x_min,
        y_min: entry.y_min,
        x_max: entry.x_max,
        y_max: entry.y_max,
        height: parseInt(entry.y_max) - parseInt(entry.y_min),
        width: parseInt(entry.x_max) - parseInt(entry.x_min),
    };

    var img_url = configration_calculation.image_url + '/v2/im/extract/'
        + entry.uploaded_hash + '/' + entry.filename + '/'
        + crop_bbox[entry.id].xmax + "/" + crop_bbox[entry.id].ymax + "/" + crop_bbox[entry.id].xmin + "/"
        + crop_bbox[entry.id].ymin + '/' + (real_bbox.height + (((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max) + (((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max));


    $('.detail-image').attr('src', img_url);
    $('iframe[name="map-view"]').attr('src', 'https://mapilio.com/embed?project_key=787lTPy6cA&class_code=inst-sign-store&edit_feature=1&center='+coord.join(',')+'&feature_id='+detail_id);
    $('input[name="captured_at"]').val(moment(image.capture_time).lang("tr").format('DD MMMM YYYY HH:mm'));

    //Add Crop Box For Detail

    let detail_image = $('.detail-image');

    detail_image.cropper({
        strict: false,
        background: false,
        guides: false,
        rotatable: false,
        zoomable: false,
        responsive: false,
        restore: true,
    });

    detail_image.on('built.cropper', function () {
        detail_image.cropper('setData', cropData[entry.id]);
        detail_image.cropper('disable');
    });

    detail_image.cropper.disabled();
}

function makeCropper(entry_id, image) {
    image.cropper({
        strict: false,
        background: false,
        guides: false,
        rotatable: false,
        zoomable: false,
        responsive: false,
        restore: true,
        // viewMode: 2,
    });

    // Event
    image.on('built.cropper', function () {
        image.cropper('setData', cropData[entry_id]);
    });

    image.on('crop.cropper', function () {
        var cropped_data = image.cropper('getCropBoxData');

        pano_details[entry_id].x_min = (crop_bbox[entry_id].xmin + cropped_data.left);
        pano_details[entry_id].y_min = (crop_bbox[entry_id].ymin + cropped_data.top);
        pano_details[entry_id].x_max = ((crop_bbox[entry_id].xmin + cropped_data.left) + cropped_data.width);
        pano_details[entry_id].y_max = ((crop_bbox[entry_id].ymin + cropped_data.top) + cropped_data.height);
    });
}

function addCropView(number) {
    $('.crop-view-box').append(`<div data-number="${number}" data-entry-id="" class="crop-entry mt-10 border-bottom border-bottom-gray">
    <div class="card-header mx-5 mx-xxl-20 px-0 pt-10 pb-0 justify-content-between align-items-center border-0">
        <div class="card-title mb-3 pl-4">
            <div class="card-label">
                <div class="font-size-h4 text-dark font-weight-bold">
                    <i class="circle-box d-inline-block mr-2">${number}</i>
                    Çekim Noktası
                </div>
            </div>
        </div>
    </div>
    <div class="card-body sign-edit-${number} shadow rounded pt-0 mx-5 mx-xxl-20 p-6 row justify-content-between d-flex bg-dark">
        <div class="clearfix position-relative mx-auto">
            <div class="picture-frame-${number}" data-width="100%">
                <img class="crop-image" data-entry-id="" data-index="${number}" src=""/>
            </div>
        </div>
    </div>
     <div class="form-group row mx-5 mx-xxl-20 mt-3">
        <div class="col-1">
           <span class="switch switch-icon">
                <label>
                     <input type="checkbox" checked="checked" class="switch-approved" data-entry-id="" name="approved_crop"/>
                     <span></span>
                </label>
           </span>
        </div>
        <label class="col-11 col-form-label">Görüntünün doğruluğunu onaylıyorum</label>
     </div>
</div>`);
}

function makeEntry(entry, number) {
    let image = entry;

    let resolution = image.resolution.split('x');
    let resolution_width = resolution[0];  //8192
    let resolution_height = resolution[1];  //4096

    pano_details[entry.id] = {
        coordy: image.lat,
        coordx: image.lon,
        uploaded_hash: image.uploaded_hash,
        filename: image.filename,
        altitude: image.altitude,
        fov: image.fov,
        vfov: image.vfov,
        pitch: image.pitch,
        heading: image.heading,
        height: resolution_height,
        width: resolution_width,
        x_min: entry.x_min,
        y_min: entry.y_min,
        x_max: entry.x_max,
        y_max: entry.y_max,
    };

    let real_bbox = {
        x_min: entry.x_min,
        y_min: entry.y_min,
        x_max: entry.x_max,
        y_max: entry.y_max,
        height: parseInt(entry.y_max) - parseInt(entry.y_min),
        width: parseInt(entry.x_max) - parseInt(entry.x_min),
    };

    let render_bbox = {
        left: (real_bbox.x_min > 100) ? 100 : 0,
        top: (real_bbox.y_min > 100) ? 100 : 0,
        width: ((resolution_width - real_bbox.x_max) > 100) ? 100 : resolution_width - real_bbox.x_max,
        height: ((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max,
    };

    crop_bbox[entry.id] = {
        xmin: parseInt(real_bbox.x_min) - render_bbox.left,
        ymin: parseInt(real_bbox.y_min) - render_bbox.top,
        xmax: parseInt(real_bbox.x_max) + render_bbox.width,
        ymax: parseInt(real_bbox.y_max) + render_bbox.height
    };

    var img_url = configration_calculation.image_url + '/v2/im/extract/'
        + entry.uploaded_hash + '/' + entry.filename + '/'
        + crop_bbox[entry.id].xmax + "/" + crop_bbox[entry.id].ymax + "/" + crop_bbox[entry.id].xmin + "/"
        + crop_bbox[entry.id].ymin + '/' + (real_bbox.height + render_bbox.height + (((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max));


    let crop_item = $('.crop-entry[data-number=' + number + ']');
    let crop_image = $('.picture-frame-' + number + ' > .crop-image');
    crop_image.attr('src', img_url);
    crop_image.attr('data-entry-id', entry.id);
    crop_item.attr('data-entry-id', entry.id);
    crop_item.find('.switch-approved').attr('data-entry-id', entry.id);

    cropData[entry.id] = {
        x: render_bbox.left,
        y: render_bbox.top,
        height: real_bbox.height,
        width: real_bbox.width,
    };

    calculated[entry.id] = {
        "x_min": real_bbox.x_min,
        "x_max": real_bbox.x_max,
        "y_min": real_bbox.y_min,
        "y_max": real_bbox.y_max,
    };
}


$('#calculate , #calculate-save').on('click', function () {

    let calculation_params = {"objects": []};
    let new_object = [];

    //Set Mode
    mode = $(this).attr('data-mode');

    //Create Calculation Params
    $.each(pano_details, function (index, value) {

        let element = $('.switch-approved[data-entry-id=' + index + ']');
        if (element.is(':checked')) {

            let object = {
                "object_id": parseInt(index),
                "coordx": parseFloat(value.coordx),
                "coordy": parseFloat(value.coordy),
                "height": parseInt(value.height),
                "width": parseInt(value.width),
                "altitude": parseFloat(value.altitude),
                "vfov": value.vfov ? parseFloat(value.vfov) : null,
                "fov": parseFloat(value.fov),
                "pitch": parseFloat(value.pitch),
                "img_url": configration_calculation.image_url + "/ai/im/" + value.uploaded_hash + "/" + value.filename,
                "heading": parseFloat(value.heading),
                "bbox_coords": [
                    parseFloat(value.x_min),
                    parseFloat(value.y_min),
                    parseFloat(value.x_max),
                    parseFloat(value.y_max)
                ]
            };
            new_object.push(object);
        } else {
            deleted_entries.push(index)
        }
    });

    calculation_params.objects.push(new_object);
    calculation_params['id'] = [detail_id];

    if (Object.keys(calculation_params.objects[0]).length > 1) {
        // //Send Calculation Request
        requestCalculation(JSON.stringify(calculation_params)).then(function (response) {

            //Check Calculation Status
            setTimeout(function () {
                checkCalculationCompleted(response.id)
            }, configration_calculation.calculation_check_time);
        });
    } else {
        errorCalculation("Hesaplama için en az 2 Çekim Noktası gereklidir.");
    }
});

function requestCalculation(data) {
    return $.ajax({
        url: configration_calculation.api_url + "/calculation",
        type: "POST",
        contentType: "application/json",
        dataType: "json",
        data: data,
        beforeSend: function () {
            completed_calculation_job = false;
            loading = showLoader("Hesaplanıyor...")
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorCalculation();
        },
        completed: function () {
            loading.close();
        }
    });
}

function checkCalculationCompleted(id) {
    $.ajax({
        url: configration_calculation.api_url + '/task/' + id,
        type: 'GET',
        success: function (result) {
            if (result.status === "SUCCESS") {
                completed_calculation_job = true;
                if (result.result.features.length) {
                    result.calculate_at = moment().format('D-MM-Y H:m:s');
                    let calculation = renderCalculation(result);

                    //Calculated Completed
                    if (mode === "save") {
                        //Save Calculation
                        saveCalculation(calculation, false).then(function () {
                            calculationCompleted(calculation);
                        });
                    } else {
                        //Show Calculation
                        calculationCompleted(calculation);
                    }
                } else {
                    errorCalculation();
                }

            } else if (result.status === "FAILURE") {
                errorCalculation();
            }
        },
        complete: function () {
            if (!completed_calculation_job) {
                setTimeout(function () {
                    checkCalculationCompleted(id)
                }, configration_calculation.calculation_check_time);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorCalculation();
        }
    });
}

function calculationCompleted(calculate_result) {

    Swal.fire({
        icon: 'success',
        customClass: {
            popup: 'swal-wide calculated-swal',
        },
        html: '<span class="calculated-title">Hesaplama tamamlandı</span>' +
            '<div class="calculated-box mt-15 p-3 row w-100">' +
            '<div class="col-8 text-left px-10 py-8">' +
            '<h2>Yeniden Hesaplanan Alan</h2>' +
            '<p>' + calculate_result.calculate_at + ' tarihinde hesaplanmıştır.</p>' +
            '</div>' +
            '<div class="col-4 calculated-area">' +
            '<span>' + parseFloat(calculate_result.area).toFixed(2) + ' m²</span>' +
            '</div>' +
            '</div>',
        focusConfirm: false,
        allowOutsideClick: false,
        showCancelButton: true,
        showConfirmButton: (mode === "calculate") ? true : false,
        confirmButtonText: "Kaydet",
        cancelButtonText: (mode === "calculate") ? "Kaydetme" : "Kapat",
    }).then((result) => {
        if (result.isConfirmed) {
            saveCalculation(calculate_result);
        }

        if (mode === 'save') {
            window.location.reload();
        }
    })
}

function saveCalculation(result, show_completed_screen = true) {
    let loading;
    result.id = detail_id;
    result.deleted_entries = deleted_entries;


    return crudX({
        url: configration_calculation.set_point_api_url,
        type: "POST",
        data: result,
        beforeSend: function () {
            loading = showLoader('Kaydediliyor...')
        },
        success: function (response) {
            if (response.success && show_completed_screen) {

                //Return SavedCalculation
                savedCalculation(result)
            } else if (!response.success) {
                loading.close();
                errorSave();
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorCalculation();
        }
    })
}

function showLoader(message = '', showCancel = true, timer = false) {
    return Swal.fire({
        title: message,
        imageUrl: configration_calculation.loading_spinner,
        allowOutsideClick: false,
        showConfirmButton: false,
        showCancelButton: showCancel,
        cancelButtonText: `İptal`,
        imageWidth: 200,
        timer: timer,
        imageHeight: 200,
    });
}

function savedCalculation(result, show_saved_screen = true) {
    $('input[name="area"]').val(parseFloat(result.area).toFixed(2) + ' m²');
    $('input[name="coordinate"]').val(parseFloat(result.lon).toFixed(7) + ", " + parseFloat(result.lat).toFixed(7));

    if (show_saved_screen) {
        Swal.fire({
            icon: 'success',
            showConfirmButton: false,
            timer: 1000
        }).then((result) => {
            window.location.reload();
        })

    }
}

function errorCalculation(message) {
    loading.close();
    message = message ?? "Lütfen daha sonra tekrar deneyiniz.";
    swal("Hesaplama Başarısız!", message, "error");
}

function errorSave() {
    swal("Kayıt Başarısız!", "Lütfen daha sonra tekrar deneyiniz.", "error");
}

function renderCalculation(response) {

    let calculation = {};

    calculation.calculate_at = response.calculate_at;
    calculation.area = response.result.features[0].properties.area;
    calculation.height = response.result.features[0].properties.height;
    calculation.width = response.result.features[0].properties.width;
    calculation.lon = response.result.features[0].geometry.coordinates[0]; //lon
    calculation.lat = response.result.features[0].geometry.coordinates[1]; //lat
    calculation.geometry = response.result.features[0].geometry;
    calculation.matchedPoints = response.result.features[0].properties.matchedPoints;

    return calculation;
}

function renderForm() {
    // Render Neighborhoods Data
    $('select[name="neighborhood"]').html();

    return $.ajax({
        url: '/api/smartax/get-neighborhoods',
        type: 'GET',
        success: function (r) {
            renderSelectField('neighborhood',r.data);
        },
        error: function () {
            errorS();
        }
    });
}

function getEntry() {
    return $.ajax({
        url: '/api/smartax/detail/' + detail_id,
        type: 'GET',
        beforeSend: function () {
            loading = showLoader("", false);
        },
        error: function (e) {
            Swal.fire({
                allowOutsideClick: false,
                title: 'Detay bilgisine ulaşılamadı!',
                text: "Tekrar denemek için lütfen pencereyi yenileyiniz.",
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Geri Dön'
            }).then((result) => {
                if (result.isConfirmed) {
                    location.href = '/admin/smartax/map';
                }
            })
        }
    });
}

function getRoads(neighborhood_id) {
    return $.ajax({
        url: '/api/smartax/get-roads',
        type: 'GET',
        data: {'parent_id': neighborhood_id},
        error: function () {
            errorS();
        }
    });
}

function getNumbers(road_id) {
    return $.ajax({
        url: '/api/smartax/get-numbers',
        type: 'GET',
        data: {'parent_id': road_id},
        error: function () {
            errorS();
        }
    });
}

function getTaxpayers(number_id) {
    return $.ajax({
        url: '/api/smartax/get-taxpayers',
        type: 'GET',
        data: {'parent_id': number_id},
        error: function () {
            errorS();
        }
    });
}

function renderEntry() {
    new Promise(function (callback) {
        getEntry().then(function (entry) {

            let value_neighborhood = entry.neighborhood_id;
            let value_road = entry.road_id;
            let value_door = entry.number_id;
            let value_taxpayer = entry.taxpayer_id;

            $('select[name="neighborhood"]').val(value_neighborhood);

            if (value_neighborhood) {
                getRoads(value_neighborhood).then((r) => {
                    renderSelectField('road', r.data);

                    $('select[name="road"]').val(value_road);
                    if (value_road) {
                        getNumbers(value_road).then((r) => {
                            renderSelectField('number', r.data);

                            $('select[name="number"]').val(value_door);

                            if (value_door) {
                                getTaxpayers(value_door).then((r) => {
                                    renderSelectField('taxpayer', r.data);

                                    $('select[name="taxpayer"]').val(value_taxpayer);

                                    callback(entry)
                                    loading.close();
                                })
                            } else {
                                loading.close();
                                callback(entry);
                            }
                        })
                    } else {
                        loading.close();
                        callback(entry);
                    }
                });
            } else {
                loading.close();
                callback(entry);
            }

            $('input[name="area"]').val(parseFloat(entry.area).toFixed(2));
            $('input[name="coordinate"]').val(parseFloat(entry.lon).toFixed(7) + ", " + parseFloat(entry.lat).toFixed(7));

            let point = getPointDetail(entry.bbox_entries);

            $('input[name="captured_at"]').val(moment(point.capture_time).lang("tr").format('DD MMMM YYYY HH:mm'));
            $('input[name="name"]').val(entry.name ?? '');

        });

    }).then((entry) => {
        renderAddress();

        detail_entry = entry.bbox_entries[Object.keys(entry.bbox_entries).length - 1];

        //Set Image
        $.each(entry.bbox_entries, function (i, entry) {
            let number = parseInt(i) + 1;
            addCropView(number);
            makeEntry(entry, number);
        });

        // Set Cropper
        // Make Cropper
        $.each($('.crop-image'), function (i, v) {
            let image = $(this);
            let entry_id = $(this).attr('data-entry-id');

            makeCropper(entry_id, image);
        });

        //Set Detail
        setDetailAttribute(detail_entry);
    })
}

$(function () {
    try {
        renderForm().then(function () {
            renderEntry();
        });
    } catch (err) {
        errorS();
    }
});

function renderSelectField(name, values) {
    $('select[name="' + name + '"]').html('<option disabled selected>...</option>');

    $.each(values, function (index, value) {
        $('select[name="' + name + '"]').append(`<option value="${value.id}">${value.name}</option>`);
    });
}

function getPointDetail(entries) {
    let entry = null, score;

    Object.values(entries).filter(function (item) {
        if (!entry) {
            entry = item;
            score = item.score;
        } else {
            if (item.score > score) {
                entry = item;
            }
        }
    });

    return entry;
}

$("select[name='neighborhood']").on('change', function () {
    let value = $(this).val();
    getRoads(value).then((r) => {
        renderSelectField('road', r.data);
        $("select[name='number']").html('');
    });

});


$("select[name='road']").on('change', function () {
    let value = $(this).val();
    getNumbers(value).then((r) => {
        renderSelectField('number', r.data);
    });
});

$("select[name='number']").on('change', function () {
    let value = $(this).val();
    getTaxpayers(value).then((r) => {
        renderSelectField('taxpayer', r.data);
    });
    renderAddress();
});

function renderAddress() {
    let address = $("select[name='neighborhood'] > option:selected").text() + " Mahallesi ";
    address += $("select[name='road'] > option:selected").text() + " Kapı No: ";
    address += $("select[name='number'] > option:selected").text();

    $('textarea[name="address"]').html(address);
}
