<?php namespace Visiosoft\SmartaxModule\Services;

use GuzzleHttp\Client;

class Mapilio
{
    private $client;
    private $token;
    private $order = 'ASC';
    private $page = 1;
    private $limit = 25;
    private $other_params = array();
    private $response;

    public function __construct($token)
    {
        $this->client = new Client(['base_uri' => 'https://end.mapilio.com/api/',]);
        $this->token = $token;
    }

    public function setOrder($order)
    {
        $this->order = $order;
    }

    public function setResponse($response)
    {
        $this->response = $response['response'];
    }

    public function setPage($page)
    {
        $this->page = $page;
    }

    public function response(){
        return $this->response;
    }

    public function setOtherParams($params)
    {
        $this->other_params = $params;
    }

    public function setLimit($limit)
    {
        $this->limit = $limit;
    }

    public function getFeatures()
    {
        $params = [
            'token' => $this->token,
            'page' => $this->page,
            'order' => $this->order,
            'limit' => $this->limit,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/list', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody(), true));

        return $this;
    }

    public function getTotalKM()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/total-km', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getNeighborhood()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/get-neighborhoods', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getRoads()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/get-roads', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getNumber()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/get-number', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTaxpayer()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/get-taxpayer', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalArea()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/total-area', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getAreaByLast6Month()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/get-area-last-6-month', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalFeature()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/total-feature', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalAreaByYear()
    {
        $params = [
            'token' => $this->token,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/total-area-by-year', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalResult()
    {
        return array_value($this->response, 'total');
    }

    public function getResult()
    {
        return array_value($this->response, 'result');
    }

    public function getResponse()
    {
        return array_value($this->response, 'response');
    }

    public function getResponseValue($key)
    {
        if (in_array($key, array_keys($this->response))) {
            return array_value($this->response, $key);
        }
        return null;
    }

    public function getData()
    {
        return array_value($this->response, 'data');
    }

    public function getFeatureDetail($id)
    {
        $params = [
            'token' => $this->token,
            'id' => $id,
        ];

        $response = $this->client->post('smartax-extension/show', [
            'form_params' => $params
        ]);

        return $this->response = json_decode($response->getBody(), true);
    }

    public function deleteFeature($id)
    {
        $params = [
            'token' => $this->token,
            'id' => $id,
        ];

        $response = $this->client->post('smartax-extension/delete', [
            'form_params' => $params
        ]);

        return $this->response = json_decode($response->getBody(), true);
    }

    public function getNeighborhoodReport()
    {
        $params = [
            'token' => $this->token
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('smartax-extension/get-neighborhood-report', [
            'form_params' => $params
        ]);

        return $this->response = json_decode($response->getBody(), true);
    }

    public function editFeature($id, $values)
    {
        $params = [
            'token' => $this->token,
            'id' => $id,
            'values' => $values
        ];

        $response = $this->client->post('smartax-extension/edit', [
            'json' => $params
        ]);

        return $this->response = json_decode($response->getBody()->getContents(), true);
    }
}