<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Visiosoft\SmartaxModule\Location\Form\LocationFormBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;

class LocationController extends AdminController
{
    public function index()
    {
        return view('module::admin/location/index');
    }

    public function create(LocationFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(LocationFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function report()
    {
        return view('module::admin.location.report');
    }

    public function list()
    {
        return view('module::admin.location.list');
    }

    public function points(PointRepositoryInterface $pointRepository)
    {
        $page = request()->all();

        $points = $pointRepository->newQuery();

        if (isset($page['sort'])) {
            $points = $points->orderBy($page['sort']['field'], $page['sort']['sort']);
        }

        $points = $points->paginate(
            $page['pagination']['perpage'],
            ['*'],
            'page',
            $page['pagination']['page']
        );

        return [
            "meta" => [
                "page" => $points->currentPage(),
                "pages" => $points->lastPage(),
                "perpage" => $page['pagination']['perpage'],
                "total" => $points->total(),
                "sort" => "desc",
                "field" => "id"
            ],
            "data" => $points->items()
        ];
    }
}
