<?php namespace Visiosoft\SmartaxModule\Point;

use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PointRepository extends EntryRepository implements PointRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var PointModel
     */
    protected $model;

    /**
     * Create a new PointRepository instance.
     *
     * @param PointModel $model
     */
    public function __construct(PointModel $model)
    {
        $this->model = $model;
    }

    public function findByKey($key)
    {
        return $this->newQuery()->where('photo_uuid',$key)->first();
    }
}
