<?php namespace Visiosoft\SmartaxModule\Commands;

use Illuminate\Support\Facades\DB;

class getGeoDoors
{
    protected $filter_params;

    public function __construct($filter_params)
    {
        $this->filter_params = $filter_params;
    }

    public function handle()
    {
        $filter = $this->filter_params;
        $filter_query = "";

        if (!empty($filter['yol_id'])) {
            $filter_query = "where yol_id=" . $filter['yol_id'];
        }

        $query = "SELECT Row_to_json(fc) AS geojson
                        FROM   (SELECT 'FeatureCollection'         AS TYPE,
                                       Array_to_json(Array_agg(f)) AS FEATURES
                                FROM   (SELECT 'Feature'
                                               AS TYPE,
                                               Json_build_object('objectid', LG.objectid, 'yol_id',
                                               LG.yol_id,
                                               'type','door',
                                               'yol_adi',
                                               LG.yol_adi, 'mahalle_id', LG.mahalle_id, 'kapi_no',
                                               LG.kapi_no)
                                               AS
                                                       properties,
                                               St_asgeojson(St_transform(LG.geom, 4326), 15, 0) :: json
                                               AS
                                                       GEOMETRY
                                        FROM   (SELECT objectid,
                                                       kapi_no,
                                                       yol_adi,
                                                       yol_id,
                                                       mahalle_id,
                                                       geom
                                                FROM   default_basaksehir_kapi $filter_query) AS LG) AS F) AS FC; ";

        $entries = DB::select($query);
        $entries = collect($entries);

        return $entries->first()->geojson;
    }
}