"use strict";

import "ol/ol.css"
import Map from "ol/Map";
import TileLayer from "ol/layer/Tile";
import { OSM, XYZ } from "ol/source";
import View from "ol/View"
import { fromLonLat } from "ol/proj"

var map = new Map({
    target: 'list-map',
    layers: [
        new TileLayer ({
            title: "basemap",
            baseLayer: true,
            visible: true,
            source: new XYZ({
                url: "http://{1-4}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png",
            })
        })
    ],
    view: new View({
        center: fromLonLat([28.798709781914212, 41.10287155927904]),
        zoom: 12,
        minZoom: 11.5,
    })
});

const conn = {
    serviceUrl: "/api/smartax/geo-features/",
    street:{
        get url() {
            return conn.serviceUrl + "yol";
        },
        rel : "mahalle_id",
        mapRel : "?mahalle_id",
        field: ["yol_adi"],
        stroke: [38, 198, 218, .75],
        hover: '#8950FC',
        width: 5,
        id: "yol_id",
        breadcrumb: 'Yol',
    },
    road:{
        get url() {
            return conn.serviceUrl + "yol";
        },
        rel: "?mahalle_id",
        mapRel: "?objectid",
        field: ["yol_adi"],
        stroke: [38, 198, 218, .75],
        hover: false,
        width: 6,
        id: "yol_id",
        breadcrumb: 'Yol Detay',
    },
    door:{
        get url() {
            return conn.serviceUrl + "kapi";
        },
        rel: "?yol_id",
        hover: false,
        mapRel: "objectid",
        field: ["kapi_no","site_adi"],
        id: "objectid",
    },
    allDoors:{
        get url() {
            return conn.serviceUrl + "kapi";
        },
        rel: "yol_id",
        hover: false,
        mapRel: "?yol_id",
        field: ["kapi_no","site_adi"],
        id: "objectid",
    },
    firstRoad: true,
    startingPoint : {
        hover: [142, 21, 34, .75],
        field: ["adi_numara"],
        id: "objectid",
        get url() {
            return conn.serviceUrl + "mahalle"
        },
    }
}

export default { map, conn }
