<?php namespace Visiosoft\SmartaxModule\Services;

use GuzzleHttp\Client;

class Mapilio
{
    private $client;
    private $token;
    private $organizationKey;
    private $projectKey;
    private $order = 'ASC';
    private $page = 1;
    private $limit = 25;
    private $other_params = array();
    private $response;

    public function __construct($token, $organizationKey, $projectKey)
    {
        $this->client = new Client(['base_uri' => 'https://end.mapilio.com/api/',]);
        $this->token = $token;
        $this->organizationKey = $organizationKey;
        $this->projectKey = $projectKey;
    }

    public function setOrder($order)
    {
        $this->order = $order;
    }

    public function setResponse($response)
    {
        $this->response = $response['response'];
    }

    public function setPage($page)
    {
        $this->page = $page;
    }

    public function setOtherParams($params)
    {
        $this->other_params = $params;
    }

    public function setLimit($limit)
    {
        $this->limit = $limit;
    }

    public function getFeatures()
    {
        $params = [
            'token' => $this->token,
            'organization_key' => $this->organizationKey,
            'project_key' => $this->projectKey,
            'page' => $this->page,
            'order' => $this->order,
            'limit' => $this->limit,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('features-v2/list', [
            'form_params' => $params
        ]);

        $this->setResponse(json_decode($response->getBody(), true));

        return $this;
    }

    public function getTotalKM()
    {
        $params = [
            'token' => $this->token,
            'organization_key' => $this->organizationKey,
            'project_key' => $this->projectKey
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->get('information/total-km', [
            'query' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalArea()
    {
        $params = [
            'token' => $this->token,
            'organization_key' => $this->organizationKey,
            'project_key' => $this->projectKey
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->get('information/total-area', [
            'query' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalFeature()
    {
        $params = [
            'token' => $this->token,
            'organization_key' => $this->organizationKey,
            'project_key' => $this->projectKey
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->get('information/total-feature', [
            'query' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalAreaByYear()
    {
        $params = [
            'token' => $this->token,
            'organization_key' => $this->organizationKey,
            'project_key' => $this->projectKey
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->get('information/total-area-by-year', [
            'query' => $params
        ]);

        $this->setResponse(json_decode($response->getBody()->getContents(), true));

        return $this;
    }

    public function getTotalResult()
    {
        return array_value($this->response, 'total');
    }

    public function getResult()
    {
        return array_value($this->response, 'result');
    }

    public function getResponse()
    {
        return array_value($this->response, 'response');
    }

    public function getResponseValue($key)
    {
        if (in_array($key, array_keys($this->response))) {
            return array_value($this->response, $key);
        }
        return null;
    }

    public function getData()
    {
        return array_value($this->response, 'data');
    }

    public function getFeatureDetail($id)
    {
        $params = [
            'token' => $this->token,
            'organization_key' => $this->organizationKey,
            'project_key' => $this->projectKey,
            'id' => $id,
        ];

        $params = array_merge($params, $this->other_params);

        $response = $this->client->post('features-v2/show', [
            'form_params' => $params
        ]);

        return $this->response = json_decode($response->getBody(), true);
    }

    public function editFeature($id, $values)
    {
        $params = [
            'token' => $this->token,
            'organization_key' => $this->organizationKey,
            'project_key' => $this->projectKey,
            'id' => $id,
            'values' => $values
        ];

        $response = $this->client->post('features-v2/edit', [
            'json' => $params
        ]);

        return $this->response = json_decode($response->getBody()->getContents(), true);
    }
}