<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Visiosoft\SmartaxModule\Bbox\Contract\BboxRepositoryInterface;
use Visiosoft\SmartaxModule\Commands\getGeoDistricts;
use Visiosoft\SmartaxModule\Commands\getGeoDoors;
use Visiosoft\SmartaxModule\Commands\getGeoRoads;
use Visiosoft\SmartaxModule\Feature\Contract\FeatureRepositoryInterface;
use Visiosoft\SmartaxModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\SmartaxModule\Measurement\Contract\MeasurementRepositoryInterface;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;
use Visiosoft\SmartaxModule\Relation\Contract\RelationRepositoryInterface;
use Visiosoft\SmartaxModule\Segmentation\Contract\SegmentationRepositoryInterface;
use Visiosoft\SmartaxModule\Services\Mapilio;
use Yajra\DataTables\DataTables;

class ApiController extends AdminController
{
    // Listeleme için tüm objeleri döndürür
    public function features()
    {
        $area_price = setting_value('visiosoft.module.smartax::tax-price', 70);
        $max_area = number_format(setting_value('visiosoft.module.smartax::max-area', '20.0'));
        $min_area = number_format(setting_value('visiosoft.module.smartax::min-area', '3.0'));
        $class = "inst-sign-store";
        $project_key = setting_value('visiosoft.module.smartax::project_key');
        $organization_key = setting_value('visiosoft.module.smartax::organization_key');
        $token = setting_value('visiosoft.module.smartax::token');

        $filters = [
            'filter_class_code' => $class,
            'filter_area_min' => $min_area,
            'filter_area_max' => $max_area
        ];

        if (request()->get('neighborhood')) {
            $filter_neighborhood = DB::table('bsk_mahalle')
                ->select(DB::raw('ST_AsText(geom) as geom'))
                ->where('id', $this->request->get('neighborhood'))
                ->first();

            if ($filter_neighborhood) {
                $filters['filter_within'] = $filter_neighborhood->geom;
            }
        }

        if (request()->get('road')) {
            $filter_road = DB::table('bsk_yol')
                ->select(DB::raw('ST_AsText(geom) as geom'))
                ->where('yolid', $this->request->get('road'))
                ->first();

            if ($filter_road) {
                $filters['filter_dwithin'] = $filter_road->geom;
            }
        }

        $mapilioApi = new Mapilio($token, $organization_key, $project_key);
        $mapilioApi->setOrder('DESC');
        $mapilioApi->setPage($this->request->get('page', 1));
        $mapilioApi->setLimit($this->request->get('limit', 25));
        $mapilioApi->setOtherParams($filters);

        $result = $mapilioApi->getFeatures();

        $entries = $result->getData();

        foreach ($entries as $key => $entry) {
            $detect_road = null;

            $detect_neighborhood = DB::table('bsk_mahalle')
                ->whereRaw('ST_Within( ST_SetSRID(ST_MakePoint(' . $entry['lon'] . ', ' . $entry['lat'] . '), 4326),default_bsk_mahalle.geom)')
                ->first();

            if ($detect_neighborhood) {
                $entries[$key]['neighborhood'] = $detect_neighborhood->ad;
            }

            $detect_numara = DB::table('bsk_numara')
                ->whereRaw('ST_Distance(
                    default_bsk_numara.geom,
                    ST_SetSRID(ST_MakePoint(' . $entry['lon'] . ', ' . $entry['lat'] . '), 4326)::geography
                ) < 25')->first();

            if ($detect_numara) {

                // SEt Number
                $entries[$key]['number'] = $detect_numara->kapino;

                // Set Road
                $detect_road = DB::table('bsk_yol')
                    ->where('yolid', $detect_numara->yolid)
                    ->first();

                if ($detect_road) {
                    $entries[$key]['road'] = $detect_road->ad;
                }
            }
        }

        return $this->response->json([
            'success' => true,
            'entries' => $entries,
            'total' => $result->getTotalResult(),
            'result' => $result->getResult(),
            'page' => $this->request->get('page', 1),
            'limit' => $this->request->get('limit', 25),
            'tax_price' => $area_price
        ]);
    }

    // Detay için Feature detayını döndürür
    public function pointDetail($id)
    {
        $project_key = setting_value('visiosoft.module.smartax::project_key');
        $organization_key = setting_value('visiosoft.module.smartax::organization_key');
        $token = setting_value('visiosoft.module.smartax::token');
        $class = "inst-sign-store";

        $mapilioApi = new Mapilio($token, $organization_key, $project_key);
        $mapilioApi->setOtherParams([
            'filter_class_code' => $class,
        ]);
        $mapilioApi->getFeatureDetail($id);
        $entry = $mapilioApi->getResponse();
        $object_information = DB::table('smartax_object_information')
            ->where('object_id', $id)->first();

        $detect_road = null;
        $mukellef = null;
        $detect_numara = DB::table('bsk_numara')
            ->whereRaw('ST_Distance(
                    default_bsk_numara.geom,
                    ST_SetSRID(ST_MakePoint(' . $entry['properties']['feature']['lon'] . ', ' . $entry['properties']['feature']['lat'] . '), 4326)::geography
                ) < 25')->first();

        if ($detect_numara) {
            $detect_road = DB::table('bsk_yol')
                ->where('yolid', $detect_numara->yolid)
                ->first();

            $mukellef = DB::table('bsk_mukellef')
                ->where('NUMARATAJI', $detect_numara->id)
                ->first();
        }

        $result = array();
        $result['id'] = $id;
        $result['created_at'] = $entry['properties']['created_at'];
        $result['updated_at'] = $entry['properties']['feature']['updated_at'];
        $result['created_by_id'] = $entry['properties']['created_by_id'];
        $result['lat'] = $object_information ? $object_information->lat : $entry['properties']['feature']['lat'];
        $result['lon'] = $object_information ? $object_information->lon : $entry['properties']['feature']['lon'];
        $result['class_code'] = $entry['properties']['feature']['class_code'];
        $result['confidence'] = $object_information ? 1.0 : $entry['properties']['feature']['confidence'];
        $result['area'] = $object_information ? $object_information->area : $entry['properties']['feature']['area'];
        $result['sequence_uuid'] = $entry['properties']['sequence_uuid'];
        $result['selected_neighborhood_id'] = $object_information ? $object_information->neighborhood : null;
        $result['selected_road_id'] = $object_information ? $object_information->road : null;
        $result['selected_number_id'] = $object_information ? $object_information->door : null;
        $result['detected_neighborhood_id'] = $detect_road ? $detect_road->mahalleid : null;
        $result['detected_road_id'] = $detect_numara ? $detect_numara->yolid : null;
        $result['detected_number_id'] = $detect_numara ? $detect_numara->id : null;
        $result['mukellef'] = $mukellef;
        $result['name'] = $object_information ? $object_information->name : null;

        $bbox_entries = array();
        foreach ($entry['properties']['matchedPoints'] as $item) {
            $item1 = array();
            $item1['id'] = $item['properties']['panoId_1'];
            $item1['x_min'] = $item['properties']['bbox_1'][0];
            $item1['y_min'] = $item['properties']['bbox_1'][1];
            $item1['x_max'] = $item['properties']['bbox_1'][2];
            $item1['y_max'] = $item['properties']['bbox_1'][3];
            $item1['score'] = $item['properties']['score_1'];
            $item1['filename'] = $item['properties']['imagery_1']['filename'];
            $item1['capture_time'] = $item['properties']['imagery_1']['capture_time'];
            $item1['resolution'] = $item['properties']['imagery_1']['resolution'];
            $item1['uploaded_hash'] = $item['properties']['imagery_1']['uploaded_hash'];
            $item1['fov'] = $item['properties']['imagery_1']['fov'];
            $item1['pitch'] = $item['properties']['imagery_1']['pitch'];
            $item1['altitude'] = $item['properties']['imagery_1']['altitude'];
            $item1['heading'] = $item['properties']['imagery_1']['heading'];
            $item1['lat'] = $item['properties']['imagery_1']['latitude'];
            $item1['lon'] = $item['properties']['imagery_1']['longitude'];

            $bbox_entries[$item1['id']] = $item1;

            $item2 = array();
            $item2['id'] = $item['properties']['panoId_2'];
            $item2['x_min'] = $item['properties']['bbox_2'][0];
            $item2['y_min'] = $item['properties']['bbox_2'][1];
            $item2['x_max'] = $item['properties']['bbox_2'][2];
            $item2['y_max'] = $item['properties']['bbox_2'][3];
            $item2['score'] = $item['properties']['score_2'];
            $item2['filename'] = $item['properties']['imagery_2']['filename'];
            $item2['capture_time'] = $item['properties']['imagery_2']['capture_time'];
            $item2['resolution'] = $item['properties']['imagery_2']['resolution'];
            $item2['uploaded_hash'] = $item['properties']['imagery_2']['uploaded_hash'];
            $item1['fov'] = $item['properties']['imagery_2']['fov'];
            $item1['pitch'] = $item['properties']['imagery_2']['pitch'];
            $item2['altitude'] = $item['properties']['imagery_2']['altitude'];
            $item2['heading'] = $item['properties']['imagery_2']['heading'];
            $item2['lat'] = $item['properties']['imagery_2']['latitude'];
            $item2['lon'] = $item['properties']['imagery_2']['longitude'];

            $bbox_entries[$item2['id']] = $item2;
        }

        /**
         * 30.11.2022
         * Hides oversized BBOX data
         */

        $bbox_entries = array_filter($bbox_entries, function ($entry) {
            return ($entry['y_max'] - $entry['y_min']) < 500;
        });

        $result['bbox_entries'] = collect(array_values($bbox_entries))->sortBy('score');

        return response()->json($result);
    }

    // Bulunan objenin BBOX değerlerini güncellememizi sağlar
    public function editPoint($id)
    {
        $status = false;
        $required_fields = ['lat', 'lon', 'area', 'calculate_at', 'height', 'width', 'calculate_at', 'geometry', 'matchedPoints'];

        try {
            if (request()->has($required_fields)) {

                $project_key = setting_value('visiosoft.module.smartax::project_key');
                $organization_key = setting_value('visiosoft.module.smartax::organization_key');
                $token = setting_value('visiosoft.module.smartax::token');


                $mapilioApi = new Mapilio($token, $organization_key, $project_key);
                $mapilioApi->editFeature($id, $this->request->all());

                if ($mapilioApi->getResponse()['success']) {
                    $status = true;
                }
            }
        } catch (\Exception $exception) {
            dd($exception->getMessage());
        }

        return response()->json(['status' => $status]);
    }

    public function getNeighborhoods()
    {
        try {
            $entries = DB::table('bsk_mahalle')
                ->select(DB::raw('default_bsk_mahalle.*'),
                    DB::raw('default_bsk_mahalle.ad as name'),
                    DB::raw('default_bsk_mahalle.id as id')
                )->orderBy('name');;

            if ($this->request->has('id')) {
                $entries = $entries->where('id', $this->request->id)
                    ->first();
            } else {
                $entries = $entries->get();
            }

            return $this->response->json(['status' => true, 'data' => $entries]);
        } catch (\Exception $exception) {
            return $this->response->json(['status' => false, 'message' => $exception->getMessage()]);
        }
    }

    public function getRoads()
    {
        try {
            $entries = DB::table('bsk_yol')
                ->select(
                    DB::raw('default_bsk_yol.ad as name'),
                    DB::raw('default_bsk_yol.yolid as id'))
                ->groupBy('yolid', 'name')
                ->orderBy('name');

            if ($this->request->has('parent_id')) {
                $entries = $entries->where('mahalleid', $this->request->parent_id)
                    ->get();
            } elseif ($this->request->has('id')) {
                $entries = $entries->where('yolid', $this->request->id)
                    ->first();
            } else {
                $entries = $entries->get();
            }

            return $this->response->json(['status' => true, 'data' => $entries]);
        } catch (\Exception $exception) {
            return $this->response->json(['status' => false, 'message' => $exception->getMessage()]);
        }
    }

    public function getNumber()
    {
        try {
            $entries = DB::table('bsk_numara')
                ->select(DB::raw('default_bsk_numara.*'),
                    DB::raw('default_bsk_numara.kapino as name'),
                    DB::raw('default_bsk_numara.id as id'));

            if ($this->request->has('parent_id')) {
                $entries = $entries->where('yolid', $this->request->parent_id)
                    ->get();
            } elseif ($this->request->has('id')) {
                $entries = $entries->where('id', $this->request->id)
                    ->first();
            } else {
                $entries = $entries->get();
            }

            return $this->response->json(['status' => true, 'data' => $entries]);
        } catch (\Exception $exception) {
            return $this->response->json(['status' => false, 'message' => $exception->getMessage()]);
        }
    }

    public function chartYear()
    {
        try {
            $area_price = setting_value('visiosoft.module.smartax::tax-price', 70);
            $max_area = number_format(setting_value('visiosoft.module.smartax::max-area', '20.0'));
            $min_area = number_format(setting_value('visiosoft.module.smartax::min-area', '3.0'));
            $class = "inst-sign-store";
            $project_key = setting_value('visiosoft.module.smartax::project_key');
            $organization_key = setting_value('visiosoft.module.smartax::organization_key');
            $token = setting_value('visiosoft.module.smartax::token');


            $mapilioApi = new Mapilio($token, $organization_key, $project_key);
            $mapilioApi->setOtherParams([
                'filter_class_code' => $class,
                'filter_area_min' => $min_area,
                'filter_area_max' => $max_area
            ]);

            $mapilioApi->getTotalAreaByYear();
            $entries = $mapilioApi->getResult();

            return $this->response->json(['status' => true, 'data' => $entries, 'area_price' => $area_price]);
        } catch (\Exception $exception) {
            return $this->response->json(['status' => false, 'message' => $exception->getMessage()]);
        }
    }

    public function editProperties($id)
    {
        $project_key = setting_value('visiosoft.module.smartax::project_key');
        $organization_key = setting_value('visiosoft.module.smartax::organization_key');
        $token = setting_value('visiosoft.module.smartax::token');
        $class = "inst-sign-store";

        $mapilioApi = new Mapilio($token, $organization_key, $project_key);
        $mapilioApi->setOtherParams([
            'filter_class_code' => $class,
        ]);
        $mapilioApi->getFeatureDetail($id);
        $entry = $mapilioApi->getResponse();

        $validator = Validator::make(request()->all(), [
            'neighborhood' => 'required',
            'road' => 'required',
            'number' => 'required',
            'area' => 'required',
            'coordinate' => 'required',
        ]);

        $coordinate = explode(',', $this->request->coordinate);

        DB::table('smartax_object_information')
            ->updateOrInsert(['object_id' => $id], [
                'neighborhood' => $this->request->get('neighborhood'),
                'road' => $this->request->get('road'),
                'door' => $this->request->get('number'),
                'lat' => $coordinate[1],
                'lon' => $coordinate[0],
                'area' => $this->request->get('area'),
                'name' => $this->request->get('properties_name')
            ]);

        if ($validator->fails()) {
            throw new \Exception($validator->errors()->first());
        }

        return $this->response->json(['status' => true]);
    }

    public function getLabelFeatures(
        PointRepositoryInterface    $repository,
        FeatureRepositoryInterface  $featureRepository,
        BboxRepositoryInterface     $bboxRepository,
        RelationRepositoryInterface $relationRepository)
    {
        $features = $featureRepository->newQuery()->orderBy('id', 'ASC')->get();

        $features->filter(function ($feature) use ($relationRepository, $bboxRepository, $repository) {
            $relations = $relationRepository->findAllBy('feature_id', $feature->id);

            $images = [];

            foreach ($relations as $relation) {
                $bbox_entries = $bboxRepository->newQuery()
                    ->where('id', $relation->bbox_id_1)
                    ->orWhere('id', $relation->bbox_id_2)
                    ->get();


                foreach ($bbox_entries as $bbox_entry) {
                    $point = $repository->findByKey($bbox_entry->photo_uuid);

                    $images[$point->id] = [
                        'id' => $feature->id,
                        'sequence_uuid' => $point->sequence_uuid,
                        'width' => $bbox_entry->x_max - $bbox_entry->x_min,
                        'height' => $bbox_entry->y_max - $bbox_entry->y_min,
                        'points' => [
                            intval($bbox_entry->x_min),
                            intval($bbox_entry->y_min),
                            $bbox_entry->x_max - $bbox_entry->x_min,
                            $bbox_entry->y_max - $bbox_entry->y_min,
                        ],
                        'bbox' => [
                            intval($bbox_entry->x_min),
                            intval($bbox_entry->y_min),
                            intval($bbox_entry->x_max),
                            intval($bbox_entry->y_max),
                        ],
                    ];

                }
            }
            $feature->images = $images;
        });

        return $this->response->json(['status' => true, 'data' => $features]);
    }

    public function getLabelImages(PointRepositoryInterface $repository)
    {
        $images = $repository->newQuery()
            ->select(['smartax_point.*', DB::raw('default_smartax_point.resolution as org_resolution')])
            ->orderBy('capture_time', 'ASC')
            ->get();

        return $this->response->json(['status' => true, 'data' => $images]);
    }

    public function saveLabelFeatures(
        MeasurementRepositoryInterface  $measurementRepository,
        RelationRepositoryInterface     $relationRepository,
        SegmentationRepositoryInterface $segmentationRepository,
        BboxRepositoryInterface         $bboxRepository,
        FeatureRepositoryInterface      $featureRepository)
    {
        try {
            $features = $this->request->features;

            foreach ($features as $feature) {

                $mixing_images = [];

                foreach (array_keys($feature['images']) as $image) {
                    $mixing_images = $this->mixingArray($image, array_keys($feature['images']), $mixing_images);
                }

                $sequence_uuid = array_first($feature['images'])['sequence_uuid'];
                $thumbnail = array_first($feature['images']);
                $thumbnail_bbox = [
                    intval($thumbnail['bbox'][0]),
                    intval($thumbnail['bbox'][1]),
                    intval($thumbnail['bbox'][2]),
                    intval($thumbnail['bbox'][3]),
                ];

                if (!isset($feature['id'])) {
                    // Entry Save (Feature)
                    $feature_entry = $featureRepository->newQuery()->create([
                        'created_by_id' => Auth::id(),
                        'lat' => $feature['calculation']['geometry']['coordinates'][1],
                        'lon' => $feature['calculation']['geometry']['coordinates'][0],
                        'class_code' => $feature['class_code'],
                        'confidence' => 1.0,
                        'sequence_uuid' => $sequence_uuid,
                        'area' => $feature['calculation']['properties']['area'],
                        'verification' => true,
                        'selected_district_id' => $feature["district"],
                        'selected_road_id' => $feature["street"],
                        'selected_door_id' => $feature["door"],
                        'properties' => json_encode(['name' => $feature['name']]),
                        'thumbnail_photo_uuid' => $thumbnail['photo_uuid'],
                        'thumbnail_photo_bbox' => json_encode($thumbnail_bbox),
                    ]);

                    // Geom Save (Feature)
                    DB::statement("UPDATE default_smartax_feature
	                                        SET  geom=ST_GeomFromGeoJSON('" . json_encode($feature['calculation']['geometry']) . "')
	                                        WHERE id=" . $feature_entry->id . ";");

                    // Entry Save (Measurement)
                    $measurementRepository->newQuery()
                        ->create([
                            'created_by_id' => Auth::id(),
                            'sequence_uuid' => $sequence_uuid,
                            'feature_id' => $feature_entry->id,
                            'avg_width' => $feature['calculation']['properties']['width'],
                            'avg_height' => $feature['calculation']['properties']['height'],
                            'avg_area' => $feature['calculation']['properties']['area'],
                        ]);

                    $mixing_images = [];
                    foreach (array_keys($feature['images']) as $image) {
                        $mixing_images = $this->mixingArray($image, array_keys($feature['images']), $mixing_images);
                    }

                    foreach ($mixing_images as $image_id => $relation_images) {
                        foreach ($relation_images as $relation_image) {

                            $check_relation = $relationRepository->newQuery()
                                ->whereIn('bbox_id_1', [$image_id, $relation_image])
                                ->whereIn('bbox_id_2', [$image_id, $relation_image])
                                ->first();

                            if (!$check_relation) {
                                $bbox_key_1 = $feature_entry->id . $image_id;
                                $bbox_key_2 = $feature_entry->id . $relation_image;

                                // Entry Save (BBOX)
                                if (!$bbox_1 = $bboxRepository->findByKey($bbox_key_1)) {
                                    $bbox_1_detail = $feature['images'][$image_id];
                                    $bbox_1 = $bboxRepository->newQuery()
                                        ->create([
                                            'created_by_id' => Auth::id(),
                                            'x_min' => $bbox_1_detail['bbox'][0],
                                            'y_min' => $bbox_1_detail['bbox'][1],
                                            'sequence_uuid' => $sequence_uuid,
                                            'x_max' => $bbox_1_detail['bbox'][2],
                                            'y_max' => $bbox_1_detail['bbox'][3],
                                            'score' => 1.0,
                                            'bbox_key' => $bbox_key_1,
                                            'photo_uuid' => $bbox_1_detail['photo_uuid'],
                                        ]);
                                }

                                if (!$bbox_2 = $bboxRepository->findByKey($bbox_key_2)) {
                                    $bbox_2_detail = $feature['images'][$relation_image];
                                    $bbox_2 = $bboxRepository->newQuery()
                                        ->create([
                                            'created_by_id' => Auth::id(),
                                            'x_min' => $bbox_2_detail['bbox'][0],
                                            'y_min' => $bbox_2_detail['bbox'][1],
                                            'sequence_uuid' => $sequence_uuid,
                                            'x_max' => $bbox_2_detail['bbox'][2],
                                            'y_max' => $bbox_2_detail['bbox'][3],
                                            'score' => 1.0,
                                            'bbox_key' => $bbox_key_2,
                                            'photo_uuid' => $bbox_2_detail['photo_uuid'],
                                        ]);
                                }

                                // Entry Save (Relation)
                                $relation = $relationRepository->newQuery()
                                    ->create([
                                        'created_by_id' => Auth::id(),
                                        'bbox_id_1' => $bbox_1->id,
                                        'bbox_id_2' => $bbox_2->id,
                                        'sequence_uuid' => $sequence_uuid,
                                        'feature_id' => $feature_entry->id,
                                    ]);

//                            // Entry Save (Location)
//                            $location = $locationRepository->newQuery()
//                                ->create([
//                                    'created_by_id' => $created_by_id,
//                                    'lat' => $bbox['geometry']['coordinates'][1],
//                                    'lon' => $bbox['geometry']['coordinates'][0],
//                                    'sequence_uuid' => $sequence_uuid,
//                                    'score' => ($bbox['properties']['score_1'] + $bbox['properties']['score_2']) / 2,
//                                    'relation_id' => $relation->id,
//                                ]);
//
//                            // Geom Save (Location)
//                            DB::statement("UPDATE default_mapilio_location
//	                                        SET  geom=ST_GeomFromGeoJSON('" . json_encode($bbox['geometry']) . "')
//	                                        WHERE id=" . $location->id . ";");

                                // Entry Save (Segmentation)
                                $segmentationRepository->newQuery()
                                    ->create([
                                        'created_by_id' => Auth::id(),
                                        'bbox_id' => $bbox_1->id,
                                        'sequence_uuid' => $sequence_uuid,
                                        'segmentation' => null,
                                    ]);

                                $segmentationRepository->newQuery()
                                    ->create([
                                        'created_by_id' => Auth::id(),
                                        'bbox_id' => $bbox_2->id,
                                        'sequence_uuid' => $sequence_uuid,
                                        'segmentation' => null,
                                    ]);
                            }
                        }
                    }
                }
            }

            return $this->response->json(['success' => true]);
        } catch (\Exception $exception) {
            return $this->response->json(['success' => false, 'message' => $exception->getMessage()]);
        }

    }

    function mixingArray($value, $values, $response)
    {
        $response[$value] = [];
        foreach ($values as $item) {
            if ($item != $value) {
                $response[$value][] = $item;
            }
        }
        return $response;
    }
}
