class SmartaxApiClient {
    constructor() {
        this.baseUrl = '/api/smartax/features';
        this.page = 1;
        this.limit = 10;
    }

    setPage(page) {
        this.page = page;
    }

    setLimit(limit) {
        this.limit = limit;
    }

    async getFeatures(suffix = '') {
        try {
            const response = await fetch(`${this.baseUrl}?page=${this.page}&limit=${this.limit}` + suffix);
            const data = await response.json();
            return data;
        } catch (error) {
            console.error('Error:', error);
            return null;
        }
    }
}

class Table {
    constructor(table, data, entries, pagination) {
        this.enties = entries;
        this.data = data;
        this.table = table;
        this.pagination = pagination;
        this.rowLinkPrefix = '';
        this.schema = {
            'id': ':value',
            'thumbnail': '<img src=":value" height="75" width="150" style="object-fit: cover">',
            'area': '<b>:value m²</b>',
            'neighborhood': ':value',
            'road': ':value',
            'number': ':value',
            'price': '<b>:value</b>',
            'created_at': ':value',
        }
    }

    setRowLinkPrefix(value) {
        this.rowLinkPrefix = value;
    }

    setPaginationClickFunction(fn) {
        this.paginationClickFunction = fn;
    }

    setTable(element) {
        this.table = element;
    }

    setPagination(element) {
        this.pagination = element;
    }

    setData(data) {
        this.data = data;
        this.setEntries(data.entries)
    }

    setEntries(entries) {
        this.enties = entries;
    }

    reset() {
        this.table.getElementsByTagName('tbody')[0].innerHTML = "";
        this.pagination.innerHTML = "";
    }

    renderPagination() {
        let currentPage = parseInt(this.data.page);
        let pageCount = Math.round(parseInt(this.data.total) / parseInt(this.data.limit));
        let startPagination = currentPage > 3 ? currentPage - 2 : 1;
        let endPagination = currentPage + 2 < pageCount ? currentPage + 2 : pageCount;

        for (let i = startPagination; i <= endPagination; i++) {
            let row = document.createElement('li');
            row.className = 'paginate_button page-item';

            if (currentPage === i) {
                row.className = row.className + " active";
            }

            let rowLink = document.createElement('a');
            rowLink.className = 'page-link cursor-pointer';
            rowLink.innerHTML = i;

            rowLink.onclick = function (page) {
                return function () {
                    table.paginationClickFunction(i);
                };
            }(i);

            row.appendChild(rowLink);
            this.pagination.appendChild(row);
        }

        if (currentPage > 3) {
            let row = document.createElement('li');
            row.className = 'paginate_button page-item';
            let rowLink = document.createElement('a');
            rowLink.className = 'page-link cursor-pointer';
            rowLink.innerHTML = '<<';
            rowLink.onclick = function (page) {
                return function () {
                    table.paginationClickFunction(1);
                };
            }(1);
            row.appendChild(rowLink);
            this.pagination.prepend(row);
        }

        if (pageCount > endPagination) {
            let row = document.createElement('li');
            row.className = 'paginate_button page-item';
            let rowLink = document.createElement('a');
            rowLink.className = 'page-link cursor-pointer';
            rowLink.innerHTML = '>>';
            rowLink.onclick = function (page) {
                return function () {
                    table.paginationClickFunction(pageCount);
                };
            }(pageCount);
            row.appendChild(rowLink);
            this.pagination.appendChild(row);
        }
    }

    render() {
        this.reset();
        this.enties.forEach(item => {
            let row = document.createElement('tr');
            row.className = 'cursor-pointer';
            let element;

            item.area = parseFloat(item.area).toFixed(2);
            item.price = parseFloat(parseFloat(item.area).toFixed(2) * parseFloat(this.data.tax_price).toFixed(2)).toFixed(2) + '₺';
            item.created_at = moment(item.created_at);
            item.created_at = item.created_at.format('DD/MM/YYYY HH:mm')

            for (const schema_index in this.schema) {
                element = document.createElement('td');
                element.innerHTML = this.schema[schema_index].replace(':value', item[schema_index] ?? '-');
                row.appendChild(element);
            }
            row.onclick = () => {
                location.href = this.rowLinkPrefix + item.id;
            }
            this.table.getElementsByTagName('tbody')[0].appendChild(row);
        })
    }
}

const smartaxApi = new SmartaxApiClient();
const table = new Table();
const urlParams = new URLSearchParams(window.location.search);
var neighborhood = urlParams.get('neighborhood');
var url;
let suffix = neighborhood ? '&neighborhood=' + neighborhood : '';
const initPage = urlParams.get('page');
const paginationClickFunction = function (page) {
    smartaxApi.setPage(page);
    smartaxApi.getFeatures(suffix)
        .then(data => {
            table.setData(data);
            table.render();
            table.renderPagination();
            console.log('Features:', data);
        })
        .catch(error => {
            console.error('Error:', error);
        });

    // Set URL parameter
    urlParams.set('page', page);
    url = `${window.location.protocol}//${window.location.host + window.location.pathname}?${urlParams}`;
    window.history.pushState({path: url}, '', url);

};

table.setTable(document.getElementById('featureList'));
table.setPagination(document.getElementById('table-pagination'));
table.setRowLinkPrefix(REQUEST_ROOT_PATH + '/admin/smartax/detail/')
table.setPaginationClickFunction(paginationClickFunction);


smartaxApi.setPage(initPage ?? 1)
smartaxApi.getFeatures(suffix)
    .then(data => {
        table.setData(data);
        table.render();
        table.renderPagination()
    })
    .catch(error => {
        console.error('Error:', error);
    });


$('.filter-dd-wrapper[data-name="neighborhood"]').on('click', '.dropdown-menu .dropdown-item', function () {
    $(this).addClass('active')
        .siblings()
        .removeClass('active')
        .closest('.dropdown')
        .find('.dropdown-toggle')
        .addClass('active')
        .find('span')
        .text($(this).text())

    neighborhood = $(this).data('val');

    urlParams.set('neighborhood', neighborhood);
    url = `${window.location.protocol}//${window.location.host + window.location.pathname}?${urlParams}`;
    window.history.pushState({path: url}, '', url);

    smartaxApi.getFeatures('&neighborhood=' + neighborhood)
        .then(data => {
            table.setData(data);
            table.render();
            table.renderPagination()
        })
        .catch(error => {
            console.error('Error:', error);
        });

    getRoads(neighborhood).then((r) => {
        $.each(r.data, function (index, value) {
            $('.filter-dd-wrapper[data-name="road"]').find('.dropdown-menu').append(`<a class="dropdown-item py-2 cursor-pointer" data-val="${value.id}">
                                    <span class="text-truncate">${value.name}</span>
                                </a>`);
        });
    });
});


$('.filter-dd-wrapper[data-name="road"]').on('click', '.dropdown-menu .dropdown-item', function () {
    $(this).addClass('active')
        .siblings()
        .removeClass('active')
        .closest('.dropdown')
        .find('.dropdown-toggle')
        .addClass('active')
        .find('span')
        .text($(this).text())

    let selected_id = $(this).data('val');

    smartaxApi.getFeatures('&neighborhood=' + neighborhood + '&road=' + selected_id)
        .then(data => {
            table.setData(data);
            table.render();
            table.renderPagination()
        })
        .catch(error => {
            console.error('Error:', error);
        });
});


function getRoads(neighborhood_id) {
    return $.ajax({
        url: '/api/smartax/get-roads',
        type: 'GET',
        data: {'parent_id': neighborhood_id},
        error: function () {
            errorS();
        }
    });
}