<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Visiosoft\SmartaxModule\Location\Form\LocationFormBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;

class LocationController extends AdminController
{
    public function index()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.location.title');

        if (request()->view === 'vertical') {
            return view('module::admin/location/index-2');
        } else {
            return view('module::admin/location/index');
        }
    }

    public function create(LocationFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(LocationFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function report()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.taxation.title');
        $this->breadcrumbs->add('Rapor Oluştur', '#');

        return view('module::admin.location.report');
    }

    public function list()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.taxation.title');
        $this->breadcrumbs->add('Tabela Listesi', '#');

        return view('module::admin.location.list');
    }

    public function points(PointRepositoryInterface $pointRepository)
    {
        $page = request()->all();

        $points = $pointRepository->newQuery();

        if (isset($page['sort'])) {
            $colExists = $pointRepository
                ->getModel()
                ->getConnection()
                ->getSchemaBuilder()
                ->hasColumn($pointRepository->getModel()->getTable(), $page['sort']['field']);

            if ($colExists) {
                $points = $points->orderBy($page['sort']['field'], $page['sort']['sort']);
            }
        }

        $points = $points->paginate(
            $page['pagination']['perpage'],
            ['*'],
            'page',
            $page['pagination']['page']
        );

        foreach ($points as $point) {
            $point->formatted_created_at = $point->created_at->format('d.m.Y');
        }

        return [
            "meta" => [
                "page" => $points->currentPage(),
                "pages" => $points->lastPage(),
                "perpage" => $page['pagination']['perpage'],
                "total" => $points->total(),
                "sort" => "desc",
                "field" => "id"
            ],
            "data" => $points->items()
        ];
    }
}
