<?php namespace Visiosoft\SmartaxModule\Forms;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SmartaxModule\Services\Mapilio;

class PropertiesFormHandler
{
    public function handle(PropertiesFormBuilder $builder, MessageBag $messageBag)
    {
        if (!$builder->canSave()) {
            return;
        }

        try {
            $values = [
                'type' => 'properties',
                'neighborhood' => $builder->getPostValue('neighborhood'),
                'road' => $builder->getPostValue('road'),
                'number' => $builder->getPostValue('number'),
                'taxpayer' => $builder->getPostValue('taxpayer'),
                'name' => $builder->getPostValue('name'),
            ];

            $token = setting_value('visiosoft.module.smartax::token');

            $mapilioApi = new Mapilio($token);
            $mapilioApi->editFeature($builder->getPostValue('feature_id'), $values);

            $response = $mapilioApi->response();

            if (!$response['status']) {
                $messageBag->error(['Düzenleme kayıt edilemedi!']);
            } else {
                $messageBag->success(['Düzenleme kayıt edildi!']);
            }
        } catch (\Exception $exception) {
            $messageBag->error(['Sistem hatası!']);
        }
    }
}
