<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\SmartaxModule\Commands\SyncMapilioFeatures;
use Visiosoft\SmartaxModule\Commands\SyncMapilioPoints;
use Visiosoft\SmartaxModule\Commands\SyncMapilioSequences;
use Visiosoft\SmartaxModule\Commands\SyncMapilioSequencesDetails;

class SyncController extends ResourceController
{
    protected $project_key;
    protected $organization_key;
    protected $token;

    public function __construct()
    {
        parent::__construct();

        $this->project_key = setting_value('visiosoft.module.smartax::project_key');
        $this->organization_key = setting_value('visiosoft.module.smartax::organization_key');
        $this->token = setting_value('visiosoft.module.smartax::token');
    }

    public function syncFeaturesAdmin()
    {
        $sync_sequences = $this->dispatch(new SyncMapilioSequences($this->token, $this->project_key, $this->organization_key));

        $sync_details = $this->dispatch(new SyncMapilioSequencesDetails($this->token));

        $sync_points = $this->dispatch(new SyncMapilioPoints($this->token));

        $sync_feature = $this->dispatch(new SyncMapilioFeatures($this->token));

        $total_count = $sync_sequences['counter'] + $sync_details['counter'] + $sync_points['counter'] + $sync_feature['counter'];

        if ($total_count > 0) {
            $this->messages->success(trans('visiosoft.module.smartax::message.data_sync', ['count' => $total_count]));
        } else {
            $this->messages->success(trans('visiosoft.module.smartax::message.all_data_added'));
        }

        return back();
    }

    public function syncPoints()
    {
        try {
            $sync_sequences = $this->dispatch(new SyncMapilioSequences($this->token, $this->project_key, $this->organization_key));

            $sync_details = $this->dispatch(new SyncMapilioSequencesDetails($this->token,10));

            $sync_points = $this->dispatch(new SyncMapilioPoints($this->token));

            $total = $sync_sequences['counter'] + $sync_details['counter'] + $sync_points['counter'];

            return $this->response->json(['success' => true, 'message' => trans('visiosoft.module.smartax::message.data_sync', ['count' => $total])]);
        } catch (\Exception $exception) {
            return $this->response->json([
                'success' => false,
                'message' => $exception->getMessage()
            ], (in_array($exception->getCode(), [400, 403, 404, 500, 501, 503])) ? $exception->getCode() : 500);
        }
    }

    public function syncFeatures()
    {
        try {
            $sync_feature = $this->dispatch(new SyncMapilioFeatures($this->token, 50));

            return $this->response->json(['success' => true, 'message' => trans('visiosoft.module.smartax::message.data_sync', ['count' => $sync_feature['counter']])]);

        } catch (\Exception $exception) {
            return $this->response->json([
                'success' => false,
                'message' => $exception->getMessage()
            ], (in_array($exception->getCode(), [400, 403, 404, 500, 501, 503])) ? $exception->getCode() : 500);
        }
    }
}
