var pano_details = {};
var calculated = {};
var cropData = {};
var crop_bbox = {};
var detail_id = $('.taxpayer-edit').data('id');
var completed_calculation_job = false;
var mode = "calculate";
var detail_entry = null;
let deleted_entries = [];

function setDetailAttribute() {

    let entry = detail_entry;
    let image = entry.detail;

    let resolution = image.resolution.split('x');
    let resolution_height = resolution[1];  //4096

    let real_bbox = {
        x_min: entry.x_min,
        y_min: entry.y_min,
        x_max: entry.x_max,
        y_max: entry.y_max,
        height: parseInt(entry.y_max) - parseInt(entry.y_min),
        width: parseInt(entry.x_max) - parseInt(entry.x_min),
    };

    var img_url = configration_calculation.image_url + '/v2/im/extract/'
        + entry.detail.uploaded_hash + '/' + entry.detail.filename + '/'
        + crop_bbox[entry.id].xmax + "/" + crop_bbox[entry.id].ymax + "/" + crop_bbox[entry.id].xmin + "/"
        + crop_bbox[entry.id].ymin + '/' + (real_bbox.height + ((real_bbox.x_min > 100) ? 100 : 0) + (((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max));


    $('.detail-image').attr('src', img_url);

    $('iframe[name="street-view"]').attr('src', 'https://www.google.com/maps/embed?pb=!4v1553797194458!6m8!1m7!1sR4K_5Z2wRHTk9el8KLTh9Q!2m2!1d' + image.lat + '!2d' + image.lon + '!3f305.15097!4f0!5f0.7820865974627469');
    $('input[name="captured_at"]').val(moment(image.capture_time).lang("tr").format('DD MMMM YYYY HH:mm'));

    //Add Crop Box For Detail

    let detail_image = $('.detail-image');

    detail_image.cropper({
        strict: false,
        background: false,
        guides: false,
        rotatable: false,
        zoomable: false,
        responsive: false,
        restore: true,
    });

    detail_image.on('built.cropper', function () {
        detail_image.cropper('setData', cropData[entry.id]);
        detail_image.cropper('disable');
    });

    detail_image.cropper.disabled();
}

function makeCropper(entry_id, image) {
    image.cropper({
        strict: false,
        background: false,
        guides: false,
        rotatable: false,
        zoomable: false,
        responsive: false,
        restore: true,
        // viewMode: 2,
    });

    // Event
    image.on('built.cropper', function () {
        image.cropper('setData', cropData[entry_id]);
    });

    image.on('crop.cropper', function () {
        var cropped_data = image.cropper('getCropBoxData');

        pano_details[entry_id].x_min = crop_bbox[entry_id].xmin + cropped_data.left;
        pano_details[entry_id].y_min = crop_bbox[entry_id].ymin + cropped_data.top;
        pano_details[entry_id].x_max = (crop_bbox[entry_id].xmin + cropped_data.left) + cropped_data.width;
        pano_details[entry_id].y_max = (crop_bbox[entry_id].ymin + cropped_data.top) + cropped_data.height;
    });
}

function addCropView(number) {
    $('.crop-view-box').append(`<div data-number="${number}" data-entry-id="" class="crop-entry mt-10 border-bottom border-bottom-gray">
    <div class="card-header mx-5 mx-xxl-20 px-0 pt-10 pb-0 justify-content-between align-items-center border-0">
        <div class="card-title mb-3 pl-4">
            <div class="card-label">
                <div class="font-size-h4 text-dark font-weight-bold">
                    <i class="circle-box d-inline-block mr-2">${number}</i>
                    Çekim Noktası
                </div>
            </div>
        </div>
    </div>
    <div class="card-body sign-edit-${number} shadow rounded pt-0 mx-5 mx-xxl-20 p-6 row justify-content-between d-flex bg-dark">
        <div class="clearfix position-relative mx-auto">
            <div class="picture-frame-${number}" data-width="100%">
                <img class="crop-image" data-entry-id="" data-index="${number}" src=""/>
            </div>
        </div>
    </div>
     <div class="form-group row mx-5 mx-xxl-20 mt-3">
        <div class="col-1">
           <span class="switch switch-icon">
                <label>
                     <input type="checkbox" checked="checked" class="switch-approved" data-entry-id="" name="approved_crop"/>
                     <span></span>
                </label>
           </span>
        </div>
        <label class="col-11 col-form-label">Görüntünün doğruluğunu onaylıyorum</label>
     </div>
</div>`);
}

function makeEntry(entry, number) {
    let image = entry.detail;

    let resolution = image.resolution.split('x');
    let resolution_width = resolution[0];  //8192
    let resolution_height = resolution[1];  //4096

    pano_details[entry.id] = {
        coordy: image.lat,
        coordx: image.lon,
        uploaded_hash: image.uploaded_hash,
        filename: image.filename,
        altitude: image.altitude,
        heading: image.heading,
        height: resolution_height,
        width: resolution_width,
        x_min: entry.x_min,
        y_min: entry.y_min,
        x_max: entry.x_max,
        y_max: entry.y_max,
    };

    let real_bbox = {
        x_min: entry.x_min,
        y_min: entry.y_min,
        x_max: entry.x_max,
        y_max: entry.y_max,
        height: parseInt(entry.y_max) - parseInt(entry.y_min),
        width: parseInt(entry.x_max) - parseInt(entry.x_min),
    };

    let render_bbox = {
        left: (real_bbox.x_min > 100) ? 100 : 0,
        top: (real_bbox.y_min > 100) ? 100 : 0,
        width: ((resolution_width - real_bbox.x_max) > 100) ? 100 : resolution_width - real_bbox.x_max,
        height: ((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max,
    };

    crop_bbox[entry.id] = {
        xmin: parseInt(real_bbox.x_min) - render_bbox.left,
        ymin: parseInt(real_bbox.y_min) - render_bbox.top,
        xmax: parseInt(real_bbox.x_max) + render_bbox.width,
        ymax: parseInt(real_bbox.y_max) + render_bbox.height
    };

    var img_url = configration_calculation.image_url + '/v2/im/extract/'
        + entry.detail.uploaded_hash + '/' + entry.detail.filename + '/'
        + crop_bbox[entry.id].xmax + "/" + crop_bbox[entry.id].ymax + "/" + crop_bbox[entry.id].xmin + "/"
        + crop_bbox[entry.id].ymin + '/' + (real_bbox.height + ((real_bbox.x_min > 100) ? 100 : 0) + (((resolution_height - real_bbox.y_max) > 100) ? 100 : resolution_height - real_bbox.y_max));

    let crop_item = $('.crop-entry[data-number=' + number + ']');
    let crop_image = $('.picture-frame-' + number + ' > .crop-image');
    crop_image.attr('src', img_url);
    crop_image.attr('data-entry-id', entry.id);
    crop_item.attr('data-entry-id', entry.id);
    crop_item.find('.switch-approved').attr('data-entry-id', entry.id);

    cropData[entry.id] = {
        x: render_bbox.left,
        y: render_bbox.top,
        height: real_bbox.height,
        width: real_bbox.width,
    };

    calculated[entry.id] = {
        "x_min": real_bbox.x_min,
        "x_max": real_bbox.x_max,
        "y_min": real_bbox.y_min,
        "y_max": real_bbox.y_max,
    };
}

$(function () {
    let loading;

    //Get Detail
    var details = crudX({
        url: '/api/smartax/detail/' + detail_id,
        type: 'GET',
        success: function (feature) {

            //Set Detail Entry
            $('input[name="area"]').val(parseFloat(feature.area).toFixed(2) + " m²");
            $('input[name="coordinate"]').val(feature.lat + ", " + feature.lon);
            detail_entry = feature.bbox_entries[Object.keys(feature.bbox_entries).length - 1];
            detailMap(detail_id, [feature.lat, feature.lon], feature.bbox_entries);

            //Set Image
            $.each(feature.bbox_entries, function (i, entry) {
                let number = parseInt(i) + 1;
                addCropView(number);
                makeEntry(entry, number);
            })
        },
        beforeSend: function () {
            loading = showLoader("", false,2000);
        },
        error: function () {
            Swal.fire({
                allowOutsideClick: false,
                title: 'Detay bilgisine ulaşılamadı!',
                text: "Tekrar denemek için lütfen pencereyi yenileyiniz.",
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Tekrar Dene'
            }).then((result) => {
                if (result.isConfirmed) {
                    location.reload();
                }
            })
        }
    });

    // Set Cropper
    details.then(function () {

        // Make Cropper
        $.each($('.crop-image'), function (i, v) {
            let image = $(this);
            let entry_id = $(this).attr('data-entry-id');

            makeCropper(entry_id, image);
        });

        //Set Detail
        setDetailAttribute(detail_entry);
    })
});


function detailMap(title, coordinate, allSigns) {
    var leaflet = new L.Map('editMap', {zoom: 20, center: new L.latLng(coordinate)});

    leaflet.addLayer(new L.TileLayer('http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png'));

    L.control.scale().addTo(leaflet);

    var leafletIcon = L.divIcon({
        html: `<span class="svg-icon svg-icon-widget-green svg-icon-3x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="24" width="24" height="0"/><path d="M5,10.5 C5,6 8,3 12.5,3 C17,3 20,6.75 20,10.5 C20,12.8325623 17.8236613,16.03566 13.470984,20.1092932 C12.9154018,20.6292577 12.0585054,20.6508331 11.4774555,20.1594925 C7.15915182,16.5078313 5,13.2880005 5,10.5 Z M12.5,12 C13.8807119,12 15,10.8807119 15,9.5 C15,8.11928813 13.8807119,7 12.5,7 C11.1192881,7 10,8.11928813 10,9.5 C10,10.8807119 11.1192881,12 12.5,12 Z" fill="#000000" fill-rule="nonzero"/></g></svg></span>`,
        bgPos: [20, 20],
        iconAnchor: [20, 37],
        popupAnchor: [0, -37],
        className: 'leaflet-marker'
    });

    L.marker(coordinate, {icon: leafletIcon}).addTo(leaflet);

    $('.leaflet-control-attribution').hide()

}

$('#calculate , #calculate-save').on('click', function () {

    let calculation_params = {"objects": []};

    //Set Mode
    mode = $(this).attr('data-mode');

    //Create Calculation Params
    $.each(pano_details, function (index, value) {

        let element = $('.switch-approved[data-entry-id=' + index + ']');
        if (element.is(':checked')) {

            let object = {
                "object_id": parseInt(index),
                "coordx": parseFloat(value.coordx),
                "coordy": parseFloat(value.coordy),
                "height": parseInt(value.height),
                "width": parseInt(value.width),
                "altitude": parseFloat(value.altitude),
                "img_url": configration_calculation.image_url + "/ai/im/" + value.uploaded_hash + "/" + value.filename,
                "heading": parseFloat(value.heading),
                "bbox_coords": [
                    parseFloat(value.x_min),
                    parseFloat(value.y_min),
                    parseFloat(value.x_max),
                    parseFloat(value.y_max)
                ]
            };

            calculation_params.objects.push(object);
        } else {
            deleted_entries.push(index)
        }
    });

    calculation_params['id'] = detail_id;

    if (calculation_params.objects.length > 1) {
        // //Send Calculation Request
        requestCalculation(JSON.stringify(calculation_params)).then(function (response) {

            //Check Calculation Status
            setTimeout(function () {
                checkCalculationCompleted(response.id)
            }, configration_calculation.calculation_check_time);
        });
    } else {
        errorCalculation("Hesaplama için en az 2 Çekim Noktası gereklidir.");
    }
});

function requestCalculation(data) {
    return $.ajax({
        url: configration_calculation.api_url + "/calculation",
        type: "POST",
        data: data,
        beforeSend: function () {
            completed_calculation_job = false;
            showLoader("Hesaplanıyor...")
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorCalculation();
        }
    });
}

function checkCalculationCompleted(id) {
    $.ajax({
        url: configration_calculation.api_url + '/task/' + id,
        type: 'GET',
        success: function (result) {
            if (result.status === "SUCCESS") {
                completed_calculation_job = true;
                result.calculate_at = moment().format('D-MM-Y H:m:s');

                let calculation = renderCalculation(result);

                //Calculated Completed
                if (mode === "save") {
                    //Save Calculation
                    saveCalculation(calculation, false).then(function () {
                        calculationCompleted(calculation);
                    });
                } else {
                    //Show Calculation
                    calculationCompleted(calculation);
                }
            } else if (result.status === "FAILURE") {
                errorCalculation();
            }
        },
        complete: function () {
            if (!completed_calculation_job) {
                setTimeout(function () {
                    checkCalculationCompleted(id)
                }, configration_calculation.calculation_check_time);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorCalculation();
        }
    });
}

function calculationCompleted(calculate_result) {

    Swal.fire({
        icon: 'success',
        customClass: {
            popup: 'swal-wide calculated-swal',
        },
        html: '<span class="calculated-title">Hesaplama tamamlandı</span>' +
            '<div class="calculated-box mt-15 p-3 row w-100">' +
            '<div class="col-8 text-left px-10 py-8">' +
            '<h2>Yeniden Hesaplanan Alan</h2>' +
            '<p>' + calculate_result.calculate_at + ' tarihinde hesaplanmıştır.</p>' +
            '</div>' +
            '<div class="col-4 calculated-area">' +
            '<span>' + parseFloat(calculate_result.area).toFixed(2) + ' m²</span>' +
            '</div>' +
            '</div>',
        focusConfirm: false,
        allowOutsideClick: false,
        showCancelButton: true,
        showConfirmButton: (mode === "calculate") ? true : false,
        confirmButtonText: "Kaydet",
        cancelButtonText: (mode === "calculate") ? "Kaydetme" : "Kapat",
    }).then((result) => {
        if (result.isConfirmed) {
            saveCalculation(calculate_result);
        }
    })
}

function saveCalculation(result, show_completed_screen = true) {
    let loading;
    result.id = detail_id;
    result.deleted_entries = deleted_entries;

    return crudX({
        url: configration_calculation.set_point_api_url,
        type: "POST",
        data: result,
        beforeSend: function () {
            loading = showLoader('Kaydediliyor...')
        },
        success: function (response) {
            if (response.status && show_completed_screen) {

                //Return SavedCalculation
                savedCalculation(result)
            } else if (!response.status) {
                loading.close();
                errorSave();
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorCalculation();
        }
    })
}

function showLoader(message = '', showCancel = true, timer = false) {
    return Swal.fire({
        title: message,
        imageUrl: configration_calculation.loading_spinner,
        allowOutsideClick: false,
        showConfirmButton: false,
        showCancelButton: showCancel,
        cancelButtonText: `İptal`,
        imageWidth: 200,
        timer: timer,
        imageHeight: 200,
    });
}

function savedCalculation(result, show_saved_screen = true) {
    $('input[name="area"]').val(parseFloat(result.area).toFixed(2) + ' m²');
    $('input[name="coordinate"]').val(result.lon + ", " + result.lat);

    if (show_saved_screen) {
        Swal.fire({
            icon: 'success',
            showConfirmButton: false,
            timer: 1000
        })
    }
}

function errorCalculation(message) {
    message = message ?? "Lütfen daha sonra tekrar deneyiniz.";
    swal("Hesaplama Başarısız!", message, "error");
}

function errorSave() {
    swal("Kayıt Başarısız!", "Lütfen daha sonra tekrar deneyiniz.", "error");
}

function renderCalculation(response) {

    let calculation = {};

    calculation.calculate_at = response.calculate_at;
    calculation.area = response.result.features[0].properties.area;
    calculation.height = response.result.features[0].properties.height;
    calculation.width = response.result.features[0].properties.width;
    calculation.lon = response.result.features[0].geometry.coordinates[0]; //lon
    calculation.lat = response.result.features[0].geometry.coordinates[1]; //lat
    calculation.geometry = response.result.features[0].geometry;
    calculation.matchedPoints = response.result.features[0].properties.matchedPoints;

    return calculation;
}
