"use strict";
let reportTable;
const filter = $('.filter-dd-wrapper')

function getSearchParameter(key) {
    let searchParams = new URLSearchParams(window.location.search);

    return searchParams.get(key)
}

// function filterTable(e) {
//     e.preventDefault();
//     var params = {};
//     $('.datatable-input').each(function () {
//         var i = $(this).data('col-index');
//         if (params[i]) {
//             params[i] += '|' + $(this).val();
//         } else {
//             params[i] = $(this).val();
//         }
//     });
//     $.each(params, function (i, val) {
//         // apply search params to datatable
//         datatable.column(i).search(val ? val : '', false, false);
//     });
//     datatable.table().draw();
// }

let initTable = function () {
    return $('#reportTable').DataTable({
        responsive: true,

        dom: `<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'p><'col-sm-12 col-md-7 dataTables_pager'li>>`,
        lengthMenu: [5, 10, 15, 25, 50],
        pageLength: 15,
        language: {
            'lengthMenu': '_MENU_',
        },
        info: false,
        searchDelay: 500,
        processing: true,
        serverSide: true,
        ajax: {
            url: '/api/smartax/features',
            type: 'GET',
            data: {
                columnsDef: [
                    'id',
                    'area',
                    'formatted_created_at',
                ],
            },
        },
        toolbar: {
            items: {
                info: true
            }
        },
        select: {
            style: "multi",
            selector: "td:first-child .checkable"
        },

        layout: {
            scroll: true, // enable/disable datatable scroll both horizontal and
            footer: false // display/hide footer
        },

        rows: {
            autoHide: false,
        },
        createdRow(row, data, dataIndex) {
            $(row).attr('data-id', data.id);
        },
        orderable: false,
        searchCols: [
            null,
            {"search": getSearchParameter('street')},
            {"search": getSearchParameter('road')},
        ],
        pagination: true,

        search: {
            input: $('#kt_datatable_search_query'),
            key: 'generalSearch'
        },

        autoWidth: false,
        columns: [
            {
                width: "70px",
                data: 'id',
                orderable: false,
            },
            {
                orderable: false,
                data: 'district_name',
            },
            {
                orderable: false,
                data: 'road_name',
            },
            {
                orderable: false,
                width: "70px",
                data: 'door_id',
            },
            {
                orderable: false,
                data: 'area',
                width: "100px",
                render: function (data, type, row) {
                    return parseFloat(data).toFixed(2) + ' m²';
                }
            },
            {
                orderable: false,
                data: 'area',
                width: "100px",
                render: function (data, type, row) {
                    return (parseFloat(data) * parseFloat(configuration.tax_price)).toFixed(2) + '₺';
                }
            },
            {
                orderable: false,
                width: "150px",
                data: 'formatted_created_at',
                sortable: false
            },
        ],
    });
};
const conn = {
    serviceUrl: "/api/smartax/geo-features/",
    street:{
        get url() {
            return conn.serviceUrl + "yol";
        },
        rel : "mahalle_id",
        mapRel : "?mahalle_id",
        field: ["yol_adi"],
        stroke: [38, 198, 218, .75],
        hover: '#8950FC',
        width: 5,
        id: "yol_id",
        breadcrumb: 'Yol',
    },
    road:{
        get url() {
            return conn.serviceUrl + "yol";
        },
        rel: "?mahalle_id",
        mapRel: "?objectid",
        field: ["yol_adi"],
        hover: false,
        width: 6,
        id: "yol_id",
        breadcrumb: 'Yol Detay',
    },
    door:{
        get url() {
            return conn.serviceUrl + "kapi";
        },
        rel: "?yol_id",
        hover: false,
        mapRel: "objectid",
        field: ["kapi_no"],
        id: "objectid",
    },
    allDoors:{
        get url() {
            return conn.serviceUrl + "kapi";
        },
        rel: "yol_id",
        hover: false,
        mapRel: "?yol_id",
        field: ["kapi_no"],
        id: "objectid",
    },
    firstRoad: true,
    startingPoint : {
        field: ["adi_numara"],
        id: "objectid",
        get url() {
            return conn.serviceUrl + "mahalle"
        },
    }
};

let initFunctions = function(){
    //TODO make filters

    // $('#dateStartFilter, #dateEndFilter').datepicker();

    // $('#keywordInput, #statusFilter, #dateStartFilter, #dateEndFilter').on('change', filterTable);

};

const expandedSearch = {
    searchParams: new URLSearchParams(window.location.search),

    queryLocation() {
        return {
            street: this.searchParams.get('street'),
            road: this.searchParams.get('road'),
        }
    },

    queryProcessed: {
        street: false,
        road: false,
    },
    ajaxRequest(params, i, v) {
        let url = params.rel ? params.url + params.rel + "=" + v : params.url;
        fetch(url).then(function (data) {
            return data.json()
        }).then(response => {
            expandedSearch.Lister(response, params, i)
        }).catch(function (error) {
            errorS();
        })
    },
    handleQuery() {
        if (this.queryLocation().street && !this.queryProcessed.street && $('.filter-dd-wrapper[data-name=street] .dropdown-item').length) {
            this.queryProcessed.street = true;

            $('.filter-dd-wrapper[data-name=street]').find(`[data-val=${this.queryLocation().street}]`).click()
        }

        if (this.queryLocation().road && !this.queryProcessed.road && $('.filter-dd-wrapper[data-name=road] .dropdown-item').length) {
            this.queryProcessed.road = true;

            $('.filter-dd-wrapper[data-name=road]').find(`[data-val=${this.queryLocation().road}]`).click()
        }
    },
    Lister(response, params, index) {
        filter.eq(index).find('.dropdown-menu').html('');

        filter.eq(index).find('.dropdown-menu').append(
            // data.filter(p=>p.src.split('.').pop() !== "json").map(p=>p.src);
            response.features.map(t => `
                <a class="dropdown-item py-2" data-val="${t.properties[params.id]}">
                    <span class="text-truncate">${params.field.map(fields => t.properties[fields])}</span>
                </a>
            `)
        );

        this.handleQuery()
    },
    init() {
        expandedSearch.ajaxRequest(conn.startingPoint, 0);
        filter.each(function (index, item) {
            filter.eq(index).on('click', '.dropdown-menu .dropdown-item', function () {
                $(this).addClass('active')
                    .siblings()
                    .removeClass('active')
                    .closest('.dropdown')
                    .find('.dropdown-toggle')
                    .addClass('active')
                    .find('span')
                    .text($(this).text())

                const nextDropdowns = $(this).closest('.filter-dd-wrapper')
                    .nextAll()
                    .find('.dropdown-toggle')
                    .removeClass('active')

                for (let dropdown of nextDropdowns) {
                    dropdown = $(dropdown)
                    const name = $(dropdown).closest('.filter-dd-wrapper').data('name')
                    if (name === 'road') {
                        $('span', dropdown).text('Sokak/Yol ara')
                    } else if (name === 'door') {
                        $('span', dropdown).text('Kapi No ara')
                    }
                }

                nextDropdowns.siblings('.dropdown-menu').html('')

                const ajaxIndex = index === 2 ? index - 1 : index

                if (index === 0) {
                    conn.firstRoad = true
                } else if (index === 1) {
                    conn.firstRoad = false
                }
                console.log(2)

                if (index !== 2) {
                    expandedSearch.ajaxRequest(
                        conn[filter.eq(ajaxIndex + 1).data('name')], ajaxIndex + 1, $(this).data('val')
                    )
                }
                console.log(3)

                const type = $(this).closest('.filter-dd-wrapper').data('name');

                if (['street', 'road'].includes(type)) {
                    const url = addMapParams(type, $(this).data('val'));
                }
                if (type == 'street') {
                    searchDistrict($(this).data('val'));
                } else if (type == 'road') {
                    searchRoad($(this).data('val'));
                } else if (type == 'door') {
                    searchDoor($(this).data('val'));
                }
            })
        });
    }
};

function searchDistrict(id) {
    reportTable.column(1).search(id, false, false);
    reportTable.table().draw();
};

function searchRoad(id) {
    reportTable.column(2).search(id, false, false);
    reportTable.table().draw();
};

function searchDoor(id) {
    reportTable.column(3).search(id, false, false);
    reportTable.table().draw();
};

function addMapParams(type, value) {
    const urlParams = new URLSearchParams(window.location.search);

    if (type === 'street') {
        urlParams.delete('road');
    }

    urlParams.set(type, value);

    const refresh = `${window.location.protocol}//${window.location.host + window.location.pathname}?${urlParams}`;
    window.history.pushState({path: refresh}, '', refresh);

    return refresh;
}

jQuery(document).ready(function () {
    $.fn.dataTable.ext.errMode = 'none';

    reportTable = initTable();

    initFunctions();

    expandedSearch.init()

});