selectedElements = [];
newFeatures = [];
myCanvas = null;
loading = false;
next_image = false;
prev_image = false;
selectedElement = null;
current_image_index = 0;
let errorAjax = false;

var features, images;
var test_features = JSON.parse('[{"class_code":"inst-sign-store","images":{"39185":{"id":39185,"bbox":[5501,1850,5890,1961],"points":[5501,1850,389,111]},"39186":{"id":39186,"bbox":[5657,1800,6154,1904],"points":[5657,1800,497,104]},"39187":{"id":39187,"bbox":[5897,1754,6424,1914],"points":[5897,1754,527,160]}}},{"class_code":"inst-sign-store","images":{"39192":{"id":39192,"bbox":[2981,1731,3155,1780],"points":[2981,1731,174,49]},"39193":{"id":39193,"bbox":[2675,1706,2877,1761],"points":[2675,1706,202,55]},"39194":{"id":39194,"bbox":[2330,1703,2561,1766],"points":[2330,1703,231,63]}}},{"class_code":"inst-sign-store","images":{"39196":{"id":39196,"bbox":[2194,1587,2605,1667],"points":[2194,1587,411,80]},"39197":{"id":39197,"bbox":[1815,1565,2235,1700],"points":[1815,1565,420,135]}}}]');
var image, selectedModal, completed_calculation_job = false;

$(document).keyup(function (e) {
    if (e.keyCode == 46) {//del key
        selectedElements.forEach(el => {
            console.log(el.node.id);
            delete newFeatures[el.node.id];
            delete features[el.node.id];
            $('#features').find('tr[id="' + el.node.id + '"]').remove();
            el.parent().remove(); //remove parent svg node


        });
    }
});

//get mouse cordinates on image
function getCordinates(event, element) {
    var rect = element[0].getBoundingClientRect();
    var x = event.pageX - rect.left;
    var y = event.pageY - rect.top;
    return {
        x: x,
        y: y
    };
}

function initTrackingLine() {
    var canvas = $('#work-canvas');
    var canvasContainer = $("#canvas-container");

    let h_line = $('.trackingline[ref="h_line"]');
    let v_line = $('.trackingline[ref="v_line"]');

    h_line.width(image.resolution[0] > canvasContainer.width() ? image.resolution[0] : canvasContainer.width());
    v_line.height(image.resolution[1] > canvasContainer.height() ? image.resolution[1] : canvasContainer.height());

    canvas.mousemove(function (event) {
        $("#tooltip-span").show();
        h_line.show();
        v_line.show();
        //TODO: replace with myCanvas.point(event.x, event.y);
        var cordinates = getCordinates(event, canvas);
        $("#tooltip-span").css({
            "left": cordinates.x + 15 + "px",
            "top": cordinates.y + 15 + "px"
        });
        $("#tooltip-span").html("x:" + cordinates.x + "<br> y:" + cordinates.y);
        h_line.css({
            top: cordinates.y
        });
        v_line.css({
            left: cordinates.x
        });

    })

    canvas.mouseout(function (event) {
        $("#tooltip-span").hide();
        h_line.hide();
        v_line.hide();
    });
}

/**
 * Attaches draw/resize listeners to shapes
 * @param {SVGElement} shape - SVGElement to attach draw/resize listeners
 */
function attachShapeListener(shape) {
    shape.on('drawstart', function () {
        console.log('drawstart')
        alreadyDrawing = true;
    });

    shape.on('drawcancel', function () {
        console.log('drawcancel')
    });

    shape.on('resizedone', function (t) {
        makeFeature(shape);
    });

    shape.on('drawstop', function () {

        makeFeature(shape);
        attachEvents(shape);

        $("#chooseModal").modal('show');
        selectedElement = shape;
        //
        // if (!selectedTool.validate(shape)) { //Don't draw an element on accidentle click
        //     shape.parent().remove();
        //     shape.remove();
        // } else {
        //     // blurImage(shape,image,workspace)
        //     attachShapeData(shape);
        //     attachEvents(shape);
        // }
    });
}

function makeFeature(shape) {
    var points = getPoints(shape);

    // Validation
    if (Number.parseInt(shape.attr("width")) < 1) {
        shape.parent().remove();
        shape.remove();
    } else {
        if (features.hasOwnProperty(shape.node.id)) {
            console.log(features[shape.node.id])
        } else {
            newFeatures[shape.node.id] = {
                shape: shape,
                x_min: points[0],
                y_min: points[1],
                x_max: points[2] + points[0],
                y_max: points[3] + points[1],
            };
        }

    }
}

function attachEvents(currentTool) {
    moveOnlyOnMoveTool(currentTool);

    // onMouse(currentTool.parent(), function (e) { //drag callback : doesn't fire on click
    //     if (currentTool.node.id === e.target.id) {
    //         updateShapeDetailInStore(currentTool.node.id, currentTool.rbox(myCanvas), getPoints(
    //             currentTool));
    //         updateFeaturePoints(currentTool);
    //     }
    // });

    currentTool.parent().on('click', function (e) {
            selectedElement = currentTool;
            selectedRect = e
            if (e.altKey) { //deep select. Helpful in case of polygon
                deselectAll();
                currentTool.selectize({
                    rotationPoint: false,
                    deepSelect: true
                });
                selectedElements.push(currentTool);
            } else {
                if (!e.ctrlKey) { //deselect rest selected elements
                    deselectAll();
                    // riot.mount('label-panel', { id : currentTool.node.id })
                }
                //select currnt element
                currentTool.selectize({
                    rotationPoint: false
                });
                selectedElements.push(currentTool);
            }
            e.stopPropagation();
        } //click call back
    );
    deselectAll();

    // riot.mount('label-panel', { id : currentTool.node.id })

}

function moveOnlyOnMoveTool(el) {
    el.on('mousedown', function (e) {
        // if (!selectedTool || selectedTool.type !== "move") {
        e.preventDefault();
        e.stopPropagation();
        // }
    });
}

function deselectAll() {
    selectedElements.forEach(el => {
        el.selectize(false, {
            deepSelect: true
        });
        el.selectize(false);
    });
    selectedElements = [];
}

// function selectAll() {
//     labellingData[imgSelected.name].shapes.forEach(shape => {
//         let el = SVG.get(shape.id);
//         el.selectize({
//             rotationPoint: false
//         });
//         selectedElements.push(el);
//     });
// }

// When create, move, resize, delete
function attachShapeData(shape) { // update data with shape detail'
    var points = getPoints(shape);
    attachShapeToImg(shape.node.id, shape.type, shape.rbox(myCanvas), points);
}

function updateFeaturePoints(shape) {
    $("[for=" + shape.node.id + "]").each((i, pointEl) => {
        updateFeaturePointPosition(SVG.get($(pointEl).attr("id")));
    });
}

function updateFeaturePointPosition(pointEl) {
    updateFeaturePointInStore(pointEl.attr("for"), pointEl.id(), pointEl.rbox(myCanvas));
}

/**
 * Returns the feature points stored in the shape
 * @param {SVGElement} shape - shape SVGElement
 */
function getPoints(shape) {
    var points;

    switch (shape.type) {
        case "rect":
            var box = shape.rbox(myCanvas);
            return [box.x, box.y, box.w, box.h];
        // case "circle":
        //     var box = shape.rbox(myCanvas);
        //     return [box.cx, box.cy, shape.attr("r")];
        // /* case "ellipse":
        //     var box = shape.rbox(myCanvas);
        //     return [box.cx, box.cy, box.rx, box.ry]; */
        case "polygon":
            //Polygon points are relative to it's container SVG
            var parentSvg = $('#' + shape.node.id).closest('svg');
            var calculatedPoints = [];
            var vector = {
                x: parseInt(parentSvg.attr("x"), 10) || 0,
                y: parseInt(parentSvg.attr("y"), 10) || 0
            }
            shape.array().value.forEach(ponitArr => {
                calculatedPoints.push([ponitArr[0] + vector.x, ponitArr[1] + vector.y]);
            });
            return calculatedPoints;
        /* case "line":
            console.log(shape.array())
            points = [];
            break;
        case "path":
            console.log(shape.array())
            points = [];
            break; */
    }
}

function drawOnCanvas() {
    var image_features = features.filter(function (item) {
        return item.images.hasOwnProperty(image.id);
    });

    image_features.forEach(function (item, index) {
        drawShape(item['images'][image.id]);
    });

    // for (var shapeIndex in image_features) {
    //     var shape = features[shapeIndex]['images'][image.id];
    //     drawShape(shape);
    // }

    // if(!imgSelected.parsed){
    //     parseFromServer({"file_id":imgSelected.id},function () {
    //         imgSelected.parsed = true;
    //         for (var shapeIndex in labellingData[imgSelected.name].shapes) {
    //             var shape = labellingData[imgSelected.name].shapes[shapeIndex];
    //             drawShape(shape);
    //         }
    //     });
    // }else{
    //     for (var shapeIndex in labellingData[imgSelected.name].shapes) {
    //         var shape = labellingData[imgSelected.name].shapes[shapeIndex];
    //         drawShape(shape);
    //     }
    // }
}


/**
 * Scales the points of the shape according to scale and type
 * @param {points[] | Array[points[]]} point
 * @param {number} scale
 * @param {string} type - type of shape
 * @returns {points[] | Array[points[]]} scaled points
 */

function scaleShapePoints(points, scale, type) {
    if (!points) return;

    if (type == "polygon") {
        return points.map(point => {
            return point.map(val => val * scale);
        });
    }
    // Return this for other shapes
    return points.map(point => point * scale);
}

/**
 * Draws a shape and all the feature points in the shape based on current image scale
 * @param {Object} shape - the shape data object as stored in labellingData
 */
function drawShape(shape) {
    if (!shape) return;
    var scale = 1;
    var currentShape;

    var rect = myCanvas.nested()
        .rect(shape.points[2] * scale, shape.points[3] * scale)
        .move(shape.points[0] * scale, shape.points[1] * scale)
        .addClass('labelbox shape')
        .id(shape.id)
        .resize();
    rect.parent().draggable();
    // //Add feature points
    currentShape = rect;

    // Sanity check, in case currentShape is empty
    if (currentShape) {
        moveOnlyOnMoveTool(currentShape);
        attachEvents(currentShape);
        attachShapeListener(currentShape);
    }
}

function initCanvas() {
    let scale = {
        width: image.resolution[0],
        height: image.resolution[1],
    };

    $("#canvas-container img").css("opacity", 1)
        .css({"width": scale.width, "height": scale.height});

    $("#work-canvas").attr({"width": scale.width, "height": scale.height});

    $('#work-canvas').html('');
    myCanvas = new SVG('work-canvas').size(scale.width, scale.height);

    drawOnCanvas();
    // viewedImage({"file_id":imgSelected.id})
    myCanvas.on('mousedown', function (event) {
        deselectAll();

        // if (selectedTool && selectedTool.type !== "point" &&) {
        console.log("mousedown")
        var currentTool = boxCreate(event, myCanvas);
        moveOnlyOnMoveTool(currentTool);
        attachShapeListener(currentTool);

        if (currentTool.type !== 'polygon') currentTool.draw(event);
        selectedElement = currentTool;
        // }
    });

    myCanvas.on('mouseup', function (event) {
        if (selectedElement) selectedElement.draw(event);
    });

    // // Listen to label point removal
    // eventBus.on('removeWorkAreaFeaturePoint', () => {
    //     self.update();
    // })

    // Make sure label panel is initially hidden/empty
    // eventBus.trigger('unmountLabelPanel');
}

function boxCreate() {
    var rect = myCanvas.nested().rect().addClass('labelbox shape').id(features.length)/* .draw() */;
    rect.resize();
    rect.parent().draggable();

    return rect;
}

function createFeature() {
    let modal = $('#createModal');
    points = getPoints(selectedElement);

    index = features.length;

    newImages = {};

    newImages[image.id] = {
        id: image.id,
        photo_uuid: image.photo_uuid,
        sequence_uuid: image.sequence_uuid,
        width: points[2] + points[0],
        height: points[3] + points[1],
        bbox: [
            points[0],
            points[1],
            points[2] + points[0],
            points[3] + points[1],
        ],
        points: [
            points[0],
            points[1],
            points[2],
            points[3],
        ],
    };

    let name = $('input[name="name"]').val();
    let district = $('select[name="district"]').val();
    let street = $('select[name="street"]').val();
    let door = $('select[name="door"]').val();

    features[index] = {
        name: name,
        district: district,
        street: street,
        door: door,
        class_code: 'inst-sign-store',
        images: newImages
    };

    $('#features').find('tbody').append(`
        <tr id="${index}">
            <td>${index + 1}</td>
            <td class="small">${name}<span class="text-muted">(1)</span></td>
        </tr>`);

    modal.modal('hide');
}

function initFeatures() {

    // var image_features = features.filter(function (item) {
    //     return item.images.hasOwnProperty(image.id);
    // });

    $('#features').find('tbody').html('');
    features.forEach(function (item, index) {
        image_id_list = Object.keys(item.images);
        properties = item.properties ? JSON.parse(item.properties) : null;
        name = '#' + item.id;
        if (properties && properties.name) {
            name = properties.name;
        }

        $('#features').find('tbody').append(`
        <tr id="${index}">
            <td>${index + 1}</td>
            <td class="small">${name}<span class="text-muted">(${image_id_list.length})</span></td>
        </tr>`);
    });
}

function getTypeByCode(code) {
    var filtered = types.filter(function (item) {
        return item.code === code;
    });

    return filtered[0];
}

function nextImageHandler() {
    var last;
    var next = images.filter(function (item, index) {
        if (image.id === item.id) {
            last = index
        }
        return last + 1 == index;
    });

    if (Object.keys(next).length > 0) {
        next_image = next[0];
    } else {
        $('.next-button').attr('disabled', true);
    }
}

function prevImageHandler() {
    if (current_image_index > 0) {
        prev_image = images[current_image_index - 1];
        $('.prev-button').attr('disabled', false);
    } else {
        $('.prev-button').attr('disabled', true);
    }
}

function prevImage() {
    image = prev_image;

    calculateCurrentImageIndex();

    $('.current-image-name').html(" " + "<span class='text-muted'>(" + image.id + ") </span>" + image.filename + "(" + parseInt(current_image_index + 1) + "/" + images.length + ")");

    var element = $('#img');
    var image_url = "https://cdn.mapilio.com/ai/im/" + image.uploaded_hash + "/" + image.filename;

    loadCanvasImage(image_url);
    element.attr('height', image.resolution[1]);
    element.attr('width', image.resolution[0]);

    myCanvas.clear();

    initCanvas();
    initTrackingLine();
    nextImageHandler();
    prevImageHandler();
}

function loadCanvasImage(source) {
    let image = $('#img');
    image.fadeOut('fast', function () {
        image.attr('src', source);
        loader('Resim Yükleniyor...');
    });

    image.one("load", function () {
        image.fadeIn('fast');
        loading.close();
    });
}

function calculateCurrentImageIndex() {
    images.filter(function (item, index) {
        if (image.id === item.id) {
            current_image_index = index;
        }
    });
    ;
}

function nextImage() {
    image = next_image;

    calculateCurrentImageIndex();

    $('.current-image-name').html(" " + "<span class='text-muted'>(" + image.id + ") </span>" + image.filename + "(" + parseInt(current_image_index + 1) + "/" + images.length + ")");

    var element = $('#img');
    var image_url = "https://cdn.mapilio.com/ai/im/" + image.uploaded_hash + "/" + image.filename;

    if (!Array.isArray(image.resolution)) {
        image.resolution = image.resolution.split('x');
    }

    loadCanvasImage(image_url);
    element.attr('height', image.resolution[1]);
    element.attr('width', image.resolution[0]);

    myCanvas.clear();

    initCanvas();
    initTrackingLine();
    nextImageHandler();
    prevImageHandler();
}

function selectModal(type) {
    $("#chooseModal").modal('hide');

    switch (type) {
        case "feature":
            selectedModal = $('#featuresModal');
            updateFeaturesModal();
            break;
        case "type":
            selectedModal = $('#typeModal');
            break;
    }

    selectedModal.modal('show');
}

function updateFeaturesModal() {
    element = $('#featuresModal');
    element.find('ul').html('');

    features.forEach(function (item, index) {
        image_id_list = Object.keys(item.images);
        addItemFeatureModal(index,item, image_id_list)
    });
}

function closeModal() {
    selectedElement.parent().remove(); //remove parent svg node
}

function selectFeature(index) {
    points = getPoints(selectedElement);
    features[index]['images'][image.id] = {
        id: image.id,
        photo_uuid: image.photo_uuid,
        sequence_uuid: image.sequence_uuid,
        bbox: [
            points[0],
            points[1],
            points[2] + points[0],
            points[3] + points[1],
        ],
        points: [
            points[0],
            points[1],
            points[2],
            points[3],
        ],
    };

    initFeatures();

    selectedModal.modal('hide');
}

function checkCalculationCompleted(id) {
    $.ajax({
        url: 'https://api.mapilio.com/task/' + id,
        type: 'GET',
        success: function (result) {
            if (result.status === "SUCCESS") {
                completed_calculation_job = true;
                result.calculate_at = moment().format('D-MM-Y H:m:s');
                loading.close();
                renderResponse(result);
                console.log("Completed", result);
            } else if (result.status === "FAILURE") {
                errorAlert("Hesaplama Başarısız!");
            }
        },
        complete: function () {
            if (!completed_calculation_job) {
                setTimeout(function () {
                    checkCalculationCompleted(id)
                }, 3000);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorAlert("Hesaplama Başarısız!");
        }
    });
}

function renderResponse(response) {
    features.forEach(function (item, index) {
        response.result.features.filter(function (response_item, response_index) {
            if (response_item.properties.match_id === index) {
                features[index].calculation = response_item;
            }
        });
    });

    renderResultModal();
}

function saveSelected() {
    approvedFeatures = features.filter(function (item, index) {
        return selectedFeatures.includes(index);
    });

    console.log(approvedFeatures)

    saveFeatures(approvedFeatures);
}

function renderResultModal() {
    let resultModal = $('#resultModal');
    resultModal.find('tbody').html('');

    features.forEach(function (value, index) {

        firstImageID = Object.keys(value.images)[0];
        firstImage = value.images[firstImageID];

        thumbnail = images.filter(function (item) {
            return item.id == firstImageID;
        });

        console.log(123)

        thumbnail = getPreview(thumbnail[0].filename, thumbnail[0].uploaded_hash, firstImage.bbox, thumbnail[0].org_resolution);

        resultModal.find('tbody').append(`
            <tr id="${index}" class="">
                        <td><input type="checkbox" data-toggle="action" name="id[]" value="${index}"></td>
                        <td data-title="thumbnail" class=""><img width="150" height="75" src="${thumbnail}"></td>
                        <td data-title="area" class="">${parseFloat(value.calculation.properties.area).toFixed(2)} m²</td>
                        <td data-title="totalImages" class="">${Object.keys(value.images).length}</td>
                    </tr>
        `);

        resultModal.find('.total-result > b').html(features.length);
    });

    addTableActions();
    resultModal.modal('show');
}

function saveFeatures(saveFeatures) {
    $.ajax({
        url: "/api/smartax/save-label-features",
        type: "POST",
        data: {
            features: saveFeatures
        },
        beforeSend: function () {
            loader("Kaydediliyor");
        },
        success: function (response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Kaydedildi',
                    showConfirmButton: false,
                    timer: 3000,
                }).then((result) => {
                    window.location.href = "/admin/smartax";
                });
            } else {
                errorAlert("Kayıt Başarısız!", 'Lütfen Tekrar Deneyin!');
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            loading.close();
            errorAlert("Hesaplama Başarısız!");
        }
    });
}


function requestCalculation(data) {
    return $.ajax({
        url: "https://api.mapilio.com/calculation",
        type: "POST",
        data: data,
        beforeSend: function () {
            completed_calculation_job = false;
            loader("Hesaplanıyor");
        },
        error: function (xhr, ajaxOptions, thrownError) {
            errorAlert("Hesaplama Başarısız!");
        }
    });
}

function errorAlert(title, message) {
    message = message ?? "Lütfen daha sonra tekrar deneyiniz.";
    swal(title, message, "error");
}


function loader(msg) {

    loading = Swal.fire({
        title: msg,
        imageUrl: spinner,
        allowOutsideClick: false,
        showConfirmButton: false,
        showCancelButton: false,
        imageWidth: 200,
        timer: false,
        imageHeight: 200,
    });
}

const getPreview = (filename, hash, bbox, resolution) => {
    resolution = resolution.split('x')
    const [x_min, y_min, x_max, y_max] = bbox;

    bbox.height = bbox[3] - bbox[1];
    bbox.width = bbox[2] - bbox[0];

    let scale_height = 0;
    let scale_width = 0;

    if (bbox.height > bbox.width) {
        scale_width = (bbox.height - bbox.width) / 2;
    } else {
        scale_height = (bbox.width - bbox.height) / 2;
    }

    const spaceBbox = {
        left: (x_min > scale_width) ? scale_width : 0,
        top: (y_min > scale_height) ? scale_height : 0,
        width: ((resolution[0] - x_max) > scale_width) ? scale_width : resolution[0] - x_max,
        height: ((resolution[1] - y_max) > scale_height) ? scale_height : resolution[1] - y_max,
    };

    let data = {
        xmin: x_min - spaceBbox.left,
        ymin: y_min - spaceBbox.top,
        xmax: x_max + spaceBbox.width,
        ymax: y_max + spaceBbox.height,
    }

    return 'https://cdn.mapilio.com/v2/im/extract/'
        + hash + '/' + filename + '/'
        + data.xmax + "/" + data.ymax + "/" + data.xmin + "/"
        + data.ymin + '/75';
};

function completeLabelIssue() {
    let calculation_params = {"objects": [], "id": []};

    //Create Calculation Params
    $.each(features, function (index, feature) {

        feature_array = [];

        if (Object.keys(feature.images).length > 1) {
            $.each(feature.images, function (image_index, feature_image) {

                var feature_image_detail = images.filter(function (item) {
                    return item.id == image_index;
                });

                feature_image_detail = feature_image_detail[0];

                resolution = feature_image_detail.org_resolution.split('x');

                feature_array.push({
                    "object_id": feature_image.id,
                    "coordx": parseFloat(feature_image_detail.lon),
                    "coordy": parseFloat(feature_image_detail.lat),
                    "height": parseInt(resolution[1]),
                    "width": parseInt(resolution[0]),
                    "altitude": parseFloat(feature_image_detail.altitude),
                    "img_url": "https://cdn.mapilio.com//ai/im/" + feature_image_detail.uploaded_hash + "/" + feature_image_detail.filename,
                    "heading": parseFloat(feature_image_detail.heading),
                    "bbox_coords": feature_image.bbox
                });
            });
            calculation_params.objects.push(feature_array)
            calculation_params.id.push(index)
        }
    });

    requestCalculation(JSON.stringify(calculation_params)).then(function (response) {

        //Check Calculation Status
        setTimeout(function () {
            checkCalculationCompleted(response.id)
        }, 3000);
    });
}

function getLabelFeatures() {
    return $.ajax({
        url: '/api/smartax/get-label-features',
        type: 'GET',
        beforeSend: function () {
            loader('Veriler yükleniyor...')
        },
        error: function () {
            errorS();
        }
    });
}

function getLabelImages() {
    return $.ajax({
        url: '/api/smartax/get-label-images',
        type: 'GET',
        beforeSend: function () {
            loader('Resimler yükleniyor...')
        },
        error: function () {
            errorS();
        }
    });
}

function getDistricts() {
    return $.ajax({
        url: '/api/smartax/get-districts',
        type: 'GET',
        error: function () {
            errorS();
        }
    });
}

function renderSelectField(name, values) {
    $('select[name="' + name + '"]').html('<option disabled selected>...</option>');

    $.each(values, function (index, value) {
        $('select[name="' + name + '"]').append(`<option value="${value.id}">${value.name}</option>`);
    });
}

$("select[name='district']").on('change', function () {
    let value = $(this).val();
    getStreets(value).then((r) => {
        renderSelectField('street', r.data);
        $("select[name='door']").html('');
    });

});


$("select[name='street']").on('change', function () {
    let value = $(this).val();
    getDoors(value).then((r) => {
        renderSelectField('door', r.data);
    });
});


function getStreets(district_id) {
    return $.ajax({
        url: '/api/smartax/get-streets',
        type: 'GET',
        data: {'parent_id': district_id},
        error: function () {
            errorS();
        }
    });
}

function getDoors(street_id) {
    return $.ajax({
        url: '/api/smartax/get-doors',
        type: 'GET',
        data: {'parent_id': street_id},
        error: function () {
            errorS();
        }
    });
}

function showCreateModal() {
    let form = $('form[name="createForm"]');
    let modal = $('#createModal');

    form.trigger('reset');

    getDistricts().then((r) => {
        renderSelectField('district', r.data);
    }).then(() => {
        $("#chooseModal").modal('hide');
        modal.modal('show');
    });
}

$(document).ready(function () {
    initData = new Promise(function (callback) {
        getLabelFeatures().then((r) => {
            features = r.data;

            getLabelImages().then((r) => {
                images = r.data;
                loading.close();
                callback(true)
            })
        })
    });

    initData.then(() => {
        console.log(features, images)

        image = images[current_image_index];


        $('.current-image-name').html(" " + "<span class='text-muted'>(" + image.id + ") </span>" + image.filename + "(" + parseInt(current_image_index + 1) + "/" + images.length + ")");

        var element = $('#img');
        var image_url = "https://cdn.mapilio.com/ai/im/" + image.uploaded_hash + "/" + image.filename;
        image.resolution = image.resolution.split('x');

        loadCanvasImage(image_url);
        element.attr('height', image.resolution[1]);
        element.attr('width', image.resolution[0]);

        nextImageHandler();
        initFeatures();
        initCanvas();
        initTrackingLine()
    });
});