"use strict";
// Class definition

var KTDatatableLocalSortDemo = function () {
    // Private functions
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    // basic demo
    var demo = function () {
        var datatable = $('#pointsDatatable').DataTable({
            responsive: true,

            // Pagination settings
            dom: `<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'p><'col-sm-12 col-md-7 dataTables_pager'li>>`,

            lengthMenu: [5, 10, 25, 50],

            pageLength: perPageSize,

            language: {
                'lengthMenu': '_MENU_',
            },

            searchDelay: 500,
            processing: true,
            serverSide: true,

            ajax: {
                url: '/api/smartax/points',
                type: 'GET',
                data: {
                    columnsDef: [
                        'id', 'DÜKKAN ADI', 'area', 'formatted_created_at', 'MAHALLE',
                        'KAPI NO', 'VERGİ TUTARI', 'DURUM'
                    ],
                },
                // data: {
                //     type: 'remote',
                //     source: {
                //         read: {
                //             method: 'GET',
                //             url: '/api/smartax/points',
                //             // sample custom headers
                //             // headers: {'x-my-custom-header': 'some value', 'x-test-header': 'the value'},
                //             map: function(raw) {
                //                 // sample data mapping
                //                 var dataSet = raw;
                //                 if (typeof raw.data !== 'undefined') {
                //                     dataSet = raw.data;
                //                 }
                //
                //                 for (let i = 0; i < dataSet.length; i++) {
                //                     dataSet[i].area = Math.round(Number(dataSet[i].area)) + ' m<small class="align-top">2</small>'
                //                 }
                //
                //                 return dataSet;
                //             },
                //         },
                //     },
                //     pageSize: perPageSize,
                //     serverPaging: true,
                //     serverFiltering: true,
                //     serverSorting: true,
                // },
            },
            // data: {
            //     type: 'remote',
            //     source: {
            //         read: {
            //             method: 'GET',
            //             url: '/api/smartax/points',
            //             // sample custom headers
            //             // headers: {'x-my-custom-header': 'some value', 'x-test-header': 'the value'},
            //             map: function(raw) {
            //                 // sample data mapping
            //                 var dataSet = raw;
            //                 if (typeof raw.data !== 'undefined') {
            //                     dataSet = raw.data;
            //                 }
            //
            //                 for (let i = 0; i < dataSet.length; i++) {
            //                     dataSet[i].area = Math.round(Number(dataSet[i].area)) + ' m<small class="align-top">2</small>'
            //                 }
            //
            //                 return dataSet;
            //             },
            //         },
            //     },
            //     pageSize: perPageSize,
            //     serverPaging: true,
            //     serverFiltering: true,
            //     serverSorting: true,
            // },

            toolbar: {
                items: {
                    info: !(typeof hideToolbarInfo !== 'undefined' && hideToolbarInfo)
                }
            },

            select: {
                style: "multi",
                selector: "td:first-child .checkable"
            },

            // layout definition
            layout: {
                scroll: true, // enable/disable datatable scroll both horizontal and
                footer: false // display/hide footer
            },

            rows: {
                autoHide: false,

                beforeTemplate: function (row, data, index) {
                    $(row).attr('data-id', data.id);
                }
            },

            // column sorting
            sortable: true,

            pagination: true,

            search: {
                input: $('#kt_datatable_search_query'),
                key: 'generalSearch'
            },

            autoWidth: false,

            // columns definition
            columns: [
                {
                    data: 'id'
                },
                {
                    data: 'DÜKKAN ADI',
                    defaultContent: '',
                },
                {
                    data: 'area'
                },
                {
                    data: 'formatted_created_at'
                },
                {
                    data: 'MAHALLE',
                    defaultContent: '',
                },
                {
                    data: 'KAPI NO',
                    defaultContent: '',
                },
                {
                    data: 'VERGİ TUTARI',
                    defaultContent: '',
                },
                {
                    data: 'DURUM',
                    defaultContent: '',
                },
            ],
            // columns: [
            //     {
            //         field: 'id',
            //         title: 'SERİ NO',
            //         sortable: 'desc',
            //         width: 100,
            //         type: 'number',
            //         selector: false,
            //     },
            //     {
            //         field: 'DÜKKAN ADI',
            //         title: 'DÜKKAN ADI',
            //         sortable: true
            //     },
            //     {
            //         field: 'area',
            //         title: 'ALAN',
            //     },
            //     {
            //         field: 'formatted_created_at',
            //         title: 'TARİH',
            //         type: 'date',
            //         format: 'DD/MM/YYYY',
            //     },
            //     {
            //         field: 'MAHALLE',
            //         title: 'MAHALLE',
            //     },
            //     {
            //         field: 'KAPI NO',
            //         title: 'KAPI NO',
            //     },
            //     {
            //         field: 'VERGİ TUTARI',
            //         title: 'VERGİ TUTARI',
            //     },
            //     {
            //         field: 'DURUM',
            //         textAlign: 'center',
            //         title: 'DURUM',
            //         template: function (row) {
            //             var status = {
            //                 0: {
            //                     'title': 'Onay Bekliyor',
            //                     'class': 'label-light-danger'
            //                 },
            //                 1: {
            //                     'title': 'Hesaplandı',
            //                     'class': ' label-light-success'
            //                 },
            //                 2: {
            //                     'title': 'İptal Edildi',
            //                     'class': ' label-light-warning'
            //                 }
            //             };
            //             return '<span class="label font-weight-bold label-lg w-75 ' + status[row.status].class + ' label-inline label-bold">' + status[row.status].title + '</span>';
            //         },
            //     }
            // ],
        });

        // $('#statusFilter').on('change', function() {
        //     datatable.search($(this).val().toLowerCase(), 'Durum');
        // }).selectpicker();

        $('#kt_search').on('click', function(e) {
            e.preventDefault();
            var params = {};
            $('.datatable-input').each(function() {
                var i = $(this).data('col-index');
                if (params[i]) {
                    params[i] += '|' + $(this).val();
                } else {
                    params[i] = $(this).val();
                }
            });
            $.each(params, function(i, val) {
                // apply search params to datatable
                datatable.column(i).search(val ? val : '', false, false);
            });
            datatable.table().draw();
        });

        $('#kt_reset').on('click', function(e) {
            e.preventDefault();
            $('.datatable-input').each(function() {
                $(this).val('');
                datatable.column($(this).data('col-index')).search('', false, false);
            });
            datatable.table().draw();
        });

        $('#dateStartFilter, #dateEndFilter').datepicker();

        datatable.on("change", ".group-checkable", (function() {
            var a = $(this).closest("table").find("td:first-child .checkable")
                , l = $(this).is(":checked");
            $(a).each((function() {
                    l ? ($(this).prop("checked", !0),
                        t.rows($(this).closest("tr")).select()) : ($(this).prop("checked", !1),
                        t.rows($(this).closest("tr")).deselect())
                }
            ))
        }))
    };

    return {
        // public functions
        init: function () {
            localStorage.removeItem('points_datatable-1-meta');
            demo();
        },
    };
}();

jQuery(document).ready(function () {
    KTDatatableLocalSortDemo.init();
});

// Redirect on row click
$('#pointsDatatable').on('click', '.datatable-row', function () {
    const id = $(this).data('id')
    if (id) {
        window.location.href = `/admin/taxpayer/detail/${id}`;
    }
})
