"use strict";
// Class definition

var KTDatatableLocalSortDemo = function () {
    // Private functions

    // basic demo
    var demo = function () {
        var datatable = $('#points_datatable').KTDatatable({
            data: {
                type: 'remote',
                source: {
                    read: {
                        url: '/ajax/smartax/points',
                        // sample custom headers
                        // headers: {'x-my-custom-header': 'some value', 'x-test-header': 'the value'},
                        map: function(raw) {
                            // sample data mapping
                            var dataSet = raw;
                            if (typeof raw.data !== 'undefined') {
                                dataSet = raw.data;
                            }

                            for (let i = 0; i < dataSet.length; i++) {
                                dataSet[i].area = Math.round(Number(dataSet[i].area)) + ' m<small class="align-top">2</small>'
                            }

                            return dataSet;
                        },
                    },
                },
                pageSize: perPageSize,
                serverPaging: true,
                serverFiltering: true,
                serverSorting: true,
            },

            select: {
                style: "multi",
                selector: "td:first-child .checkable"
            },

            // layout definition
            layout: {
                scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
                footer: false, // display/hide footer
            },

            // column sorting
            sortable: true,

            pagination: true,

            search: {
                input: $('#kt_datatable_search_query'),
                key: 'generalSearch'
            },

            // columns definition
            columns: [
                {
                    field: 'id',
                    title: 'SERİ NO',
                    sortable: 'desc',
                    width: 100,
                    type: 'number',
                    selector: false,
                },
                {
                    field: 'DÜKKAN ADI',
                    title: 'DÜKKAN ADI',
                    sortable: true
                },
                {
                    field: 'area',
                    title: 'ALAN',
                },
                {
                    field: 'created_at',
                    title: 'TARİH',
                    type: 'date',
                    format: 'DD/MM/YYYY',
                },
                {
                    field: 'MAHALLE',
                    title: 'MAHALLE',
                },
                {
                    field: 'KAPI NO',
                    title: 'KAPI NO',
                },
                {
                    field: 'VERGİ TUTARI',
                    title: 'VERGİ TUTARI',
                },
                {
                    field: 'DURUM',
                    textAlign: 'center',
                    title: 'DURUM',
                    template: function (row) {
                        var status = {
                            0: {
                                'title': 'Onay Bekliyor',
                                'class': 'label-light-danger'
                            },
                            1: {
                                'title': 'Hesaplandı',
                                'class': ' label-light-success'
                            },
                            2: {
                                'title': 'İptal Edildi',
                                'class': ' label-light-warning'
                            }
                        };
                        return '<span class="label font-weight-bold label-lg w-75 ' + status[row.status].class + ' label-inline label-bold">' + status[row.status].title + '</span>';
                    },
                }
            ],
        });

        $('#kt_reset').on('click', function(e) {
            e.preventDefault();
            $('.datatable-input').each(function() {
                $(this).val('');
                datatable.column($(this).data('col-index')).search('', false, false);
            });
            datatable.reload();
        });

        datatable.on("change", ".group-checkable", (function() {
                var a = $(this).closest("table").find("td:first-child .checkable")
                    , l = $(this).is(":checked");
                $(a).each((function() {
                        l ? ($(this).prop("checked", !0),
                            t.rows($(this).closest("tr")).select()) : ($(this).prop("checked", !1),
                            t.rows($(this).closest("tr")).deselect())
                    }
                ))
            }
        ))
    };

    return {
        // public functions
        init: function () {
            demo();
            $('#date-1, #date-2').selectpicker();
            $('#kt_datepicker_1,#kt_datepicker_2').datepicker();
        },
    };
}();

jQuery(document).ready(function () {
    KTDatatableLocalSortDemo.init();
});
