<?php namespace Visiosoft\SmartaxModule\InstallerForm;

use Anomaly\InstallerModule\Installer\Form\Validator\ValidateConnection;
use Anomaly\InstallerModule\Installer\Form\Validator\ValidateDatabase;
use Anomaly\InstallerModule\Installer\Form\Validator\ValidateDomain;


class InstallerFormFields
{
    public function handle(InstallerFormBuilder $builder)
    {
        $builder->setFields(
            [
                'project_key'       => [
                    'label'        => 'Project Key',
//                    'instructions' => 'anomaly.module.installer::field.database_driver.instructions',
                    'type'         => 'anomaly.field_type.text',
                    'value'        => config('visiosoft.module.smartax::project_key'),
                    'required'     => true,
                ],
                'organization_key'         => [
                    'label'        => 'Organization Key',
//                    'placeholder'  => 'anomaly.module.installer::field.database_host.placeholder',
//                    'instructions' => 'anomaly.module.installer::field.database_host.instructions',
                    'type'         => 'anomaly.field_type.text',
                    'value'        => config('visiosoft.module.smartax::organization_key'),
                    'required'     => true,
                ],
                'token'         => [
                    'label'        => 'Token',
//                    'placeholder'  => 'anomaly.module.installer::field.database_port.placeholder',
//                    'instructions' => 'anomaly.module.installer::field.database_port.instructions',
                    'type'         => 'anomaly.field_type.text',
                    'value'        => config('visiosoft.module.smartax::token'),
                    'required'     => true,
                ],

                /*
                 * Administrator Fields
                 */
                'admin_username'        => [
                    'label'        => 'anomaly.module.installer::field.admin_username.label',
                    'placeholder'  => 'anomaly.module.installer::field.admin_username.placeholder',
                    'instructions' => 'anomaly.module.installer::field.admin_username.instructions',
                    'value'        => "smartax",
                    'type'         => 'anomaly.field_type.text',
                    'required'     => true,
                ],
                'admin_email'           => [
                    'label'        => 'anomaly.module.installer::field.admin_email.label',
                    'placeholder'  => 'anomaly.module.installer::field.admin_email.placeholder',
                    'instructions' => 'anomaly.module.installer::field.admin_email.instructions',
                    'type'         => 'anomaly.field_type.email',
                    'value'        => "admin@smartax.com",
                    'required'     => true,
                ],
                'admin_password'        => [
                    'label'        => 'anomaly.module.installer::field.admin_password.label',
                    'placeholder'  => 'anomaly.module.installer::field.admin_password.placeholder',
                    'instructions' => 'anomaly.module.installer::field.admin_password.instructions',
                    'type'         => 'anomaly.field_type.text',
                    'required'     => true,
                    'config'       => [
                        'type' => 'password',
                    ],
                ],
            ]
        );
    }
}
