<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\SmartaxModule\Commands\SyncMapilioFeature;
use Visiosoft\SmartaxModule\Commands\SyncMapilioPoint;

class SyncController extends ResourceController
{
    protected $project_key;
    protected $organization_key;
    protected $token;

    public function __construct()
    {
        parent::__construct();

        $this->project_key = setting_value('visiosoft.module.smartax::project_key');
        $this->organization_key = setting_value('visiosoft.module.smartax::organization_key');
        $this->token = setting_value('visiosoft.module.smartax::token');
    }

    public function syncFeatures()
    {
        $count = $this->dispatch(new SyncMapilioFeature($this->token, $this->project_key, $this->organization_key));

        return $this->response->json(['success' => true, 'message' => trans('visiosoft.module.smartax::message.data_sync', ['count' => $count['counter']])]);
    }

    public function syncFeaturesAdmin()
    {
        $count_feature = $this->dispatch(new SyncMapilioFeature($this->token, $this->project_key, $this->organization_key));

        $count_points = $this->dispatch(new SyncMapilioPoint($this->token, $this->project_key, $this->organization_key));

        $total_count = $count_feature['counter'] + $count_points['counter'];

        if ($total_count > 0) {
            $this->messages->success(trans('visiosoft.module.smartax::message.data_sync', ['count' => $total_count]));
        } else {
            $this->messages->success(trans('visiosoft.module.smartax::message.all_data_added'));
        }

        return back();
    }

    public function syncPoints()
    {
        $count = $this->dispatch(new SyncMapilioPoint($this->token, $this->project_key, $this->organization_key));

        return $this->response->json(['success' => true, 'message' => trans('visiosoft.module.smartax::message.data_sync', ['count' => $count['counter']])]);
    }
}
